<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaign StructType
 * @subpackage Structs
 */
class Campaign extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The CampaignCode
     * @var string
     */
    public $CampaignCode;
    /**
     * The CampaignName
     * @var string
     */
    public $CampaignName;
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The FromFirstName
     * @var string
     */
    public $FromFirstName;
    /**
     * The FromLastName
     * @var string
     */
    public $FromLastName;
    /**
     * The FromEmailAddress
     * @var string
     */
    public $FromEmailAddress;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * Constructor method for Campaign
     * @uses Campaign::setCustomFieldDetail()
     * @uses Campaign::setCampaignCode()
     * @uses Campaign::setCampaignName()
     * @uses Campaign::setActive()
     * @uses Campaign::setFromFirstName()
     * @uses Campaign::setFromLastName()
     * @uses Campaign::setFromEmailAddress()
     * @uses Campaign::setInternalNote()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param string $campaignCode
     * @param string $campaignName
     * @param bool $active
     * @param string $fromFirstName
     * @param string $fromLastName
     * @param string $fromEmailAddress
     * @param string $internalNote
     */
    public function __construct(array $customFieldDetail = array(), $campaignCode = null, $campaignName = null, $active = null, $fromFirstName = null, $fromLastName = null, $fromEmailAddress = null, $internalNote = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setCampaignCode($campaignCode)
            ->setCampaignName($campaignName)
            ->setActive($active)
            ->setFromFirstName($fromFirstName)
            ->setFromLastName($fromLastName)
            ->setFromEmailAddress($fromEmailAddress)
            ->setInternalNote($internalNote);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$campaignCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($campaignCustomFieldDetailItem) ? get_class($campaignCustomFieldDetailItem) : sprintf('%s(%s)', gettype($campaignCustomFieldDetailItem), var_export($campaignCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\Campaign
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\Campaign
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get CampaignCode value
     * @return string|null
     */
    public function getCampaignCode()
    {
        return $this->CampaignCode;
    }
    /**
     * Set CampaignCode value
     * @param string $campaignCode
     * @return \StructType\Campaign
     */
    public function setCampaignCode($campaignCode = null)
    {
        // validation for constraint: string
        if (!is_null($campaignCode) && !is_string($campaignCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignCode, true), gettype($campaignCode)), __LINE__);
        }
        $this->CampaignCode = $campaignCode;
        return $this;
    }
    /**
     * Get CampaignName value
     * @return string|null
     */
    public function getCampaignName()
    {
        return $this->CampaignName;
    }
    /**
     * Set CampaignName value
     * @param string $campaignName
     * @return \StructType\Campaign
     */
    public function setCampaignName($campaignName = null)
    {
        // validation for constraint: string
        if (!is_null($campaignName) && !is_string($campaignName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignName, true), gettype($campaignName)), __LINE__);
        }
        $this->CampaignName = $campaignName;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Campaign
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get FromFirstName value
     * @return string|null
     */
    public function getFromFirstName()
    {
        return $this->FromFirstName;
    }
    /**
     * Set FromFirstName value
     * @param string $fromFirstName
     * @return \StructType\Campaign
     */
    public function setFromFirstName($fromFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($fromFirstName) && !is_string($fromFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromFirstName, true), gettype($fromFirstName)), __LINE__);
        }
        $this->FromFirstName = $fromFirstName;
        return $this;
    }
    /**
     * Get FromLastName value
     * @return string|null
     */
    public function getFromLastName()
    {
        return $this->FromLastName;
    }
    /**
     * Set FromLastName value
     * @param string $fromLastName
     * @return \StructType\Campaign
     */
    public function setFromLastName($fromLastName = null)
    {
        // validation for constraint: string
        if (!is_null($fromLastName) && !is_string($fromLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromLastName, true), gettype($fromLastName)), __LINE__);
        }
        $this->FromLastName = $fromLastName;
        return $this;
    }
    /**
     * Get FromEmailAddress value
     * @return string|null
     */
    public function getFromEmailAddress()
    {
        return $this->FromEmailAddress;
    }
    /**
     * Set FromEmailAddress value
     * @param string $fromEmailAddress
     * @return \StructType\Campaign
     */
    public function setFromEmailAddress($fromEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromEmailAddress) && !is_string($fromEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEmailAddress, true), gettype($fromEmailAddress)), __LINE__);
        }
        $this->FromEmailAddress = $fromEmailAddress;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Campaign
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Campaign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
