<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetPaymentDetail StructType
 * @subpackage Structs
 */
class BudgetPaymentDetail extends AbstractStructBase
{
    /**
     * The PaymentDetailId
     * @var string
     */
    public $PaymentDetailId;
    /**
     * The PaymentName
     * @var string
     */
    public $PaymentName;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The PaymentDate
     * @var string
     */
    public $PaymentDate;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for BudgetPaymentDetail
     * @uses BudgetPaymentDetail::setPaymentDetailId()
     * @uses BudgetPaymentDetail::setPaymentName()
     * @uses BudgetPaymentDetail::setPaymentType()
     * @uses BudgetPaymentDetail::setPaymentDate()
     * @uses BudgetPaymentDetail::setAmount()
     * @uses BudgetPaymentDetail::setReferenceNumber()
     * @uses BudgetPaymentDetail::setCurrency()
     * @uses BudgetPaymentDetail::setCurrencyCode()
     * @param string $paymentDetailId
     * @param string $paymentName
     * @param string $paymentType
     * @param string $paymentDate
     * @param float $amount
     * @param string $referenceNumber
     * @param string $currency
     * @param string $currencyCode
     */
    public function __construct($paymentDetailId = null, $paymentName = null, $paymentType = null, $paymentDate = null, $amount = null, $referenceNumber = null, $currency = null, $currencyCode = null)
    {
        $this
            ->setPaymentDetailId($paymentDetailId)
            ->setPaymentName($paymentName)
            ->setPaymentType($paymentType)
            ->setPaymentDate($paymentDate)
            ->setAmount($amount)
            ->setReferenceNumber($referenceNumber)
            ->setCurrency($currency)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get PaymentDetailId value
     * @return string|null
     */
    public function getPaymentDetailId()
    {
        return $this->PaymentDetailId;
    }
    /**
     * Set PaymentDetailId value
     * @param string $paymentDetailId
     * @return \StructType\BudgetPaymentDetail
     */
    public function setPaymentDetailId($paymentDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetailId) && !is_string($paymentDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetailId, true), gettype($paymentDetailId)), __LINE__);
        }
        $this->PaymentDetailId = $paymentDetailId;
        return $this;
    }
    /**
     * Get PaymentName value
     * @return string|null
     */
    public function getPaymentName()
    {
        return $this->PaymentName;
    }
    /**
     * Set PaymentName value
     * @param string $paymentName
     * @return \StructType\BudgetPaymentDetail
     */
    public function setPaymentName($paymentName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentName) && !is_string($paymentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentName, true), gettype($paymentName)), __LINE__);
        }
        $this->PaymentName = $paymentName;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\BudgetPaymentDetail
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\BudgetPaymentDetail
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\BudgetPaymentDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\BudgetPaymentDetail
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\BudgetPaymentDetail
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\BudgetPaymentDetail
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BudgetPaymentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
