<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetItem StructType
 * @subpackage Structs
 */
class BudgetItem extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The CostDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CostDetail[]
     */
    public $CostDetail;
    /**
     * The SavingsDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SavingsDetail[]
     */
    public $SavingsDetail;
    /**
     * The BudgetPaymentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BudgetPaymentDetail[]
     */
    public $BudgetPaymentDetail;
    /**
     * The AllocationCategoryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AllocationCategoryDetail[]
     */
    public $AllocationCategoryDetail;
    /**
     * The AssociatedRegistrants
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AssociatedRegistrants[]
     */
    public $AssociatedRegistrants;
    /**
     * The ItemName
     * @var string
     */
    public $ItemName;
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * The ItemType
     * @var string
     */
    public $ItemType;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The RFPId
     * @var string
     */
    public $RFPId;
    /**
     * The RFPCode
     * @var string
     */
    public $RFPCode;
    /**
     * The CategoryName
     * @var string
     */
    public $CategoryName;
    /**
     * The SubCategoryId
     * @var string
     */
    public $SubCategoryId;
    /**
     * The SubCategoryName
     * @var string
     */
    public $SubCategoryName;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ProductId
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * @var string
     */
    public $ProductName;
    /**
     * The VendorType
     * @var string
     */
    public $VendorType;
    /**
     * The VendorId
     * @var string
     */
    public $VendorId;
    /**
     * The VendorName
     * @var string
     */
    public $VendorName;
    /**
     * The VendorDescription
     * @var string
     */
    public $VendorDescription;
    /**
     * The VendorAddress1
     * @var string
     */
    public $VendorAddress1;
    /**
     * The VendorAddress2
     * @var string
     */
    public $VendorAddress2;
    /**
     * The VendorAddress3
     * @var string
     */
    public $VendorAddress3;
    /**
     * The VendorCity
     * @var string
     */
    public $VendorCity;
    /**
     * The VendorState
     * @var string
     */
    public $VendorState;
    /**
     * The VendorPostalCode
     * @var string
     */
    public $VendorPostalCode;
    /**
     * The VendorCountry
     * @var string
     */
    public $VendorCountry;
    /**
     * The VendorURL
     * @var string
     */
    public $VendorURL;
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorContactFirstName
     * @var string
     */
    public $VendorContactFirstName;
    /**
     * The VendorContactLastName
     * @var string
     */
    public $VendorContactLastName;
    /**
     * The VendorContactTitle
     * @var string
     */
    public $VendorContactTitle;
    /**
     * The VendorContactPhone
     * @var string
     */
    public $VendorContactPhone;
    /**
     * The VendorContactFax
     * @var string
     */
    public $VendorContactFax;
    /**
     * The VendorContactEmailAddress
     * @var string
     */
    public $VendorContactEmailAddress;
    /**
     * The VendorContactAdditionalInformation
     * @var string
     */
    public $VendorContactAdditionalInformation;
    /**
     * The GLName
     * @var string
     */
    public $GLName;
    /**
     * The GLCode
     * @var string
     */
    public $GLCode;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ConversionRate
     * @var float
     */
    public $ConversionRate;
    /**
     * The TaxOnGratuity
     * @var bool
     */
    public $TaxOnGratuity;
    /**
     * The CostAvoidance
     * @var float
     */
    public $CostAvoidance;
    /**
     * The CostIncludesTax
     * @var bool
     */
    public $CostIncludesTax;
    /**
     * The AvoidanceDescription
     * @var string
     */
    public $AvoidanceDescription;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The ItemDate
     * @var string
     */
    public $ItemDate;
    /**
     * Constructor method for BudgetItem
     * @uses BudgetItem::setCustomFieldDetail()
     * @uses BudgetItem::setCostDetail()
     * @uses BudgetItem::setSavingsDetail()
     * @uses BudgetItem::setBudgetPaymentDetail()
     * @uses BudgetItem::setAllocationCategoryDetail()
     * @uses BudgetItem::setAssociatedRegistrants()
     * @uses BudgetItem::setItemName()
     * @uses BudgetItem::setItemCode()
     * @uses BudgetItem::setItemType()
     * @uses BudgetItem::setEventId()
     * @uses BudgetItem::setEventCode()
     * @uses BudgetItem::setRFPId()
     * @uses BudgetItem::setRFPCode()
     * @uses BudgetItem::setCategoryName()
     * @uses BudgetItem::setSubCategoryId()
     * @uses BudgetItem::setSubCategoryName()
     * @uses BudgetItem::setStatus()
     * @uses BudgetItem::setProductId()
     * @uses BudgetItem::setProductName()
     * @uses BudgetItem::setVendorType()
     * @uses BudgetItem::setVendorId()
     * @uses BudgetItem::setVendorName()
     * @uses BudgetItem::setVendorDescription()
     * @uses BudgetItem::setVendorAddress1()
     * @uses BudgetItem::setVendorAddress2()
     * @uses BudgetItem::setVendorAddress3()
     * @uses BudgetItem::setVendorCity()
     * @uses BudgetItem::setVendorState()
     * @uses BudgetItem::setVendorPostalCode()
     * @uses BudgetItem::setVendorCountry()
     * @uses BudgetItem::setVendorURL()
     * @uses BudgetItem::setVendorCode()
     * @uses BudgetItem::setVendorContactFirstName()
     * @uses BudgetItem::setVendorContactLastName()
     * @uses BudgetItem::setVendorContactTitle()
     * @uses BudgetItem::setVendorContactPhone()
     * @uses BudgetItem::setVendorContactFax()
     * @uses BudgetItem::setVendorContactEmailAddress()
     * @uses BudgetItem::setVendorContactAdditionalInformation()
     * @uses BudgetItem::setGLName()
     * @uses BudgetItem::setGLCode()
     * @uses BudgetItem::setCurrency()
     * @uses BudgetItem::setCurrencyCode()
     * @uses BudgetItem::setConversionRate()
     * @uses BudgetItem::setTaxOnGratuity()
     * @uses BudgetItem::setCostAvoidance()
     * @uses BudgetItem::setCostIncludesTax()
     * @uses BudgetItem::setAvoidanceDescription()
     * @uses BudgetItem::setInternalNote()
     * @uses BudgetItem::setLastModifiedDate()
     * @uses BudgetItem::setItemDate()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param \StructType\CostDetail[] $costDetail
     * @param \StructType\SavingsDetail[] $savingsDetail
     * @param \StructType\BudgetPaymentDetail[] $budgetPaymentDetail
     * @param \StructType\AllocationCategoryDetail[] $allocationCategoryDetail
     * @param \StructType\AssociatedRegistrants[] $associatedRegistrants
     * @param string $itemName
     * @param string $itemCode
     * @param string $itemType
     * @param string $eventId
     * @param string $eventCode
     * @param string $rFPId
     * @param string $rFPCode
     * @param string $categoryName
     * @param string $subCategoryId
     * @param string $subCategoryName
     * @param string $status
     * @param string $productId
     * @param string $productName
     * @param string $vendorType
     * @param string $vendorId
     * @param string $vendorName
     * @param string $vendorDescription
     * @param string $vendorAddress1
     * @param string $vendorAddress2
     * @param string $vendorAddress3
     * @param string $vendorCity
     * @param string $vendorState
     * @param string $vendorPostalCode
     * @param string $vendorCountry
     * @param string $vendorURL
     * @param string $vendorCode
     * @param string $vendorContactFirstName
     * @param string $vendorContactLastName
     * @param string $vendorContactTitle
     * @param string $vendorContactPhone
     * @param string $vendorContactFax
     * @param string $vendorContactEmailAddress
     * @param string $vendorContactAdditionalInformation
     * @param string $gLName
     * @param string $gLCode
     * @param string $currency
     * @param string $currencyCode
     * @param float $conversionRate
     * @param bool $taxOnGratuity
     * @param float $costAvoidance
     * @param bool $costIncludesTax
     * @param string $avoidanceDescription
     * @param string $internalNote
     * @param string $lastModifiedDate
     * @param string $itemDate
     */
    public function __construct(array $customFieldDetail = array(), array $costDetail = array(), array $savingsDetail = array(), array $budgetPaymentDetail = array(), array $allocationCategoryDetail = array(), array $associatedRegistrants = array(), $itemName = null, $itemCode = null, $itemType = null, $eventId = null, $eventCode = null, $rFPId = null, $rFPCode = null, $categoryName = null, $subCategoryId = null, $subCategoryName = null, $status = null, $productId = null, $productName = null, $vendorType = null, $vendorId = null, $vendorName = null, $vendorDescription = null, $vendorAddress1 = null, $vendorAddress2 = null, $vendorAddress3 = null, $vendorCity = null, $vendorState = null, $vendorPostalCode = null, $vendorCountry = null, $vendorURL = null, $vendorCode = null, $vendorContactFirstName = null, $vendorContactLastName = null, $vendorContactTitle = null, $vendorContactPhone = null, $vendorContactFax = null, $vendorContactEmailAddress = null, $vendorContactAdditionalInformation = null, $gLName = null, $gLCode = null, $currency = null, $currencyCode = null, $conversionRate = null, $taxOnGratuity = null, $costAvoidance = null, $costIncludesTax = null, $avoidanceDescription = null, $internalNote = null, $lastModifiedDate = null, $itemDate = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setCostDetail($costDetail)
            ->setSavingsDetail($savingsDetail)
            ->setBudgetPaymentDetail($budgetPaymentDetail)
            ->setAllocationCategoryDetail($allocationCategoryDetail)
            ->setAssociatedRegistrants($associatedRegistrants)
            ->setItemName($itemName)
            ->setItemCode($itemCode)
            ->setItemType($itemType)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setRFPId($rFPId)
            ->setRFPCode($rFPCode)
            ->setCategoryName($categoryName)
            ->setSubCategoryId($subCategoryId)
            ->setSubCategoryName($subCategoryName)
            ->setStatus($status)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setVendorType($vendorType)
            ->setVendorId($vendorId)
            ->setVendorName($vendorName)
            ->setVendorDescription($vendorDescription)
            ->setVendorAddress1($vendorAddress1)
            ->setVendorAddress2($vendorAddress2)
            ->setVendorAddress3($vendorAddress3)
            ->setVendorCity($vendorCity)
            ->setVendorState($vendorState)
            ->setVendorPostalCode($vendorPostalCode)
            ->setVendorCountry($vendorCountry)
            ->setVendorURL($vendorURL)
            ->setVendorCode($vendorCode)
            ->setVendorContactFirstName($vendorContactFirstName)
            ->setVendorContactLastName($vendorContactLastName)
            ->setVendorContactTitle($vendorContactTitle)
            ->setVendorContactPhone($vendorContactPhone)
            ->setVendorContactFax($vendorContactFax)
            ->setVendorContactEmailAddress($vendorContactEmailAddress)
            ->setVendorContactAdditionalInformation($vendorContactAdditionalInformation)
            ->setGLName($gLName)
            ->setGLCode($gLCode)
            ->setCurrency($currency)
            ->setCurrencyCode($currencyCode)
            ->setConversionRate($conversionRate)
            ->setTaxOnGratuity($taxOnGratuity)
            ->setCostAvoidance($costAvoidance)
            ->setCostIncludesTax($costIncludesTax)
            ->setAvoidanceDescription($avoidanceDescription)
            ->setInternalNote($internalNote)
            ->setLastModifiedDate($lastModifiedDate)
            ->setItemDate($itemDate);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetItemCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$budgetItemCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($budgetItemCustomFieldDetailItem) ? get_class($budgetItemCustomFieldDetailItem) : sprintf('%s(%s)', gettype($budgetItemCustomFieldDetailItem), var_export($budgetItemCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\BudgetItem
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\BudgetItem
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get CostDetail value
     * @return \StructType\CostDetail[]|null
     */
    public function getCostDetail()
    {
        return $this->CostDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCostDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostDetailForArrayConstraintsFromSetCostDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetItemCostDetailItem) {
            // validation for constraint: itemType
            if (!$budgetItemCostDetailItem instanceof \StructType\CostDetail) {
                $invalidValues[] = is_object($budgetItemCostDetailItem) ? get_class($budgetItemCostDetailItem) : sprintf('%s(%s)', gettype($budgetItemCostDetailItem), var_export($budgetItemCostDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CostDetail property can only contain items of type \StructType\CostDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CostDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CostDetail[] $costDetail
     * @return \StructType\BudgetItem
     */
    public function setCostDetail(array $costDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($costDetailArrayErrorMessage = self::validateCostDetailForArrayConstraintsFromSetCostDetail($costDetail))) {
            throw new \InvalidArgumentException($costDetailArrayErrorMessage, __LINE__);
        }
        $this->CostDetail = $costDetail;
        return $this;
    }
    /**
     * Add item to CostDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CostDetail $item
     * @return \StructType\BudgetItem
     */
    public function addToCostDetail(\StructType\CostDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CostDetail) {
            throw new \InvalidArgumentException(sprintf('The CostDetail property can only contain items of type \StructType\CostDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CostDetail[] = $item;
        return $this;
    }
    /**
     * Get SavingsDetail value
     * @return \StructType\SavingsDetail[]|null
     */
    public function getSavingsDetail()
    {
        return $this->SavingsDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSavingsDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSavingsDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSavingsDetailForArrayConstraintsFromSetSavingsDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetItemSavingsDetailItem) {
            // validation for constraint: itemType
            if (!$budgetItemSavingsDetailItem instanceof \StructType\SavingsDetail) {
                $invalidValues[] = is_object($budgetItemSavingsDetailItem) ? get_class($budgetItemSavingsDetailItem) : sprintf('%s(%s)', gettype($budgetItemSavingsDetailItem), var_export($budgetItemSavingsDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SavingsDetail property can only contain items of type \StructType\SavingsDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SavingsDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SavingsDetail[] $savingsDetail
     * @return \StructType\BudgetItem
     */
    public function setSavingsDetail(array $savingsDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($savingsDetailArrayErrorMessage = self::validateSavingsDetailForArrayConstraintsFromSetSavingsDetail($savingsDetail))) {
            throw new \InvalidArgumentException($savingsDetailArrayErrorMessage, __LINE__);
        }
        $this->SavingsDetail = $savingsDetail;
        return $this;
    }
    /**
     * Add item to SavingsDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SavingsDetail $item
     * @return \StructType\BudgetItem
     */
    public function addToSavingsDetail(\StructType\SavingsDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SavingsDetail) {
            throw new \InvalidArgumentException(sprintf('The SavingsDetail property can only contain items of type \StructType\SavingsDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SavingsDetail[] = $item;
        return $this;
    }
    /**
     * Get BudgetPaymentDetail value
     * @return \StructType\BudgetPaymentDetail[]|null
     */
    public function getBudgetPaymentDetail()
    {
        return $this->BudgetPaymentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setBudgetPaymentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBudgetPaymentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBudgetPaymentDetailForArrayConstraintsFromSetBudgetPaymentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetItemBudgetPaymentDetailItem) {
            // validation for constraint: itemType
            if (!$budgetItemBudgetPaymentDetailItem instanceof \StructType\BudgetPaymentDetail) {
                $invalidValues[] = is_object($budgetItemBudgetPaymentDetailItem) ? get_class($budgetItemBudgetPaymentDetailItem) : sprintf('%s(%s)', gettype($budgetItemBudgetPaymentDetailItem), var_export($budgetItemBudgetPaymentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BudgetPaymentDetail property can only contain items of type \StructType\BudgetPaymentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BudgetPaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\BudgetPaymentDetail[] $budgetPaymentDetail
     * @return \StructType\BudgetItem
     */
    public function setBudgetPaymentDetail(array $budgetPaymentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($budgetPaymentDetailArrayErrorMessage = self::validateBudgetPaymentDetailForArrayConstraintsFromSetBudgetPaymentDetail($budgetPaymentDetail))) {
            throw new \InvalidArgumentException($budgetPaymentDetailArrayErrorMessage, __LINE__);
        }
        $this->BudgetPaymentDetail = $budgetPaymentDetail;
        return $this;
    }
    /**
     * Add item to BudgetPaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\BudgetPaymentDetail $item
     * @return \StructType\BudgetItem
     */
    public function addToBudgetPaymentDetail(\StructType\BudgetPaymentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BudgetPaymentDetail) {
            throw new \InvalidArgumentException(sprintf('The BudgetPaymentDetail property can only contain items of type \StructType\BudgetPaymentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BudgetPaymentDetail[] = $item;
        return $this;
    }
    /**
     * Get AllocationCategoryDetail value
     * @return \StructType\AllocationCategoryDetail[]|null
     */
    public function getAllocationCategoryDetail()
    {
        return $this->AllocationCategoryDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAllocationCategoryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllocationCategoryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllocationCategoryDetailForArrayConstraintsFromSetAllocationCategoryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetItemAllocationCategoryDetailItem) {
            // validation for constraint: itemType
            if (!$budgetItemAllocationCategoryDetailItem instanceof \StructType\AllocationCategoryDetail) {
                $invalidValues[] = is_object($budgetItemAllocationCategoryDetailItem) ? get_class($budgetItemAllocationCategoryDetailItem) : sprintf('%s(%s)', gettype($budgetItemAllocationCategoryDetailItem), var_export($budgetItemAllocationCategoryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllocationCategoryDetail property can only contain items of type \StructType\AllocationCategoryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllocationCategoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AllocationCategoryDetail[] $allocationCategoryDetail
     * @return \StructType\BudgetItem
     */
    public function setAllocationCategoryDetail(array $allocationCategoryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($allocationCategoryDetailArrayErrorMessage = self::validateAllocationCategoryDetailForArrayConstraintsFromSetAllocationCategoryDetail($allocationCategoryDetail))) {
            throw new \InvalidArgumentException($allocationCategoryDetailArrayErrorMessage, __LINE__);
        }
        $this->AllocationCategoryDetail = $allocationCategoryDetail;
        return $this;
    }
    /**
     * Add item to AllocationCategoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AllocationCategoryDetail $item
     * @return \StructType\BudgetItem
     */
    public function addToAllocationCategoryDetail(\StructType\AllocationCategoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllocationCategoryDetail) {
            throw new \InvalidArgumentException(sprintf('The AllocationCategoryDetail property can only contain items of type \StructType\AllocationCategoryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllocationCategoryDetail[] = $item;
        return $this;
    }
    /**
     * Get AssociatedRegistrants value
     * @return \StructType\AssociatedRegistrants[]|null
     */
    public function getAssociatedRegistrants()
    {
        return $this->AssociatedRegistrants;
    }
    /**
     * This method is responsible for validating the values passed to the setAssociatedRegistrants method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociatedRegistrants method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssociatedRegistrantsForArrayConstraintsFromSetAssociatedRegistrants(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetItemAssociatedRegistrantsItem) {
            // validation for constraint: itemType
            if (!$budgetItemAssociatedRegistrantsItem instanceof \StructType\AssociatedRegistrants) {
                $invalidValues[] = is_object($budgetItemAssociatedRegistrantsItem) ? get_class($budgetItemAssociatedRegistrantsItem) : sprintf('%s(%s)', gettype($budgetItemAssociatedRegistrantsItem), var_export($budgetItemAssociatedRegistrantsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssociatedRegistrants property can only contain items of type \StructType\AssociatedRegistrants, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssociatedRegistrants value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociatedRegistrants[] $associatedRegistrants
     * @return \StructType\BudgetItem
     */
    public function setAssociatedRegistrants(array $associatedRegistrants = array())
    {
        // validation for constraint: array
        if ('' !== ($associatedRegistrantsArrayErrorMessage = self::validateAssociatedRegistrantsForArrayConstraintsFromSetAssociatedRegistrants($associatedRegistrants))) {
            throw new \InvalidArgumentException($associatedRegistrantsArrayErrorMessage, __LINE__);
        }
        $this->AssociatedRegistrants = $associatedRegistrants;
        return $this;
    }
    /**
     * Add item to AssociatedRegistrants value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociatedRegistrants $item
     * @return \StructType\BudgetItem
     */
    public function addToAssociatedRegistrants(\StructType\AssociatedRegistrants $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssociatedRegistrants) {
            throw new \InvalidArgumentException(sprintf('The AssociatedRegistrants property can only contain items of type \StructType\AssociatedRegistrants, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssociatedRegistrants[] = $item;
        return $this;
    }
    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }
    /**
     * Set ItemName value
     * @param string $itemName
     * @return \StructType\BudgetItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\BudgetItem
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get ItemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param string $itemType
     * @return \StructType\BudgetItem
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: string
        if (!is_null($itemType) && !is_string($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\BudgetItem
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\BudgetItem
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get RFPId value
     * @return string|null
     */
    public function getRFPId()
    {
        return $this->RFPId;
    }
    /**
     * Set RFPId value
     * @param string $rFPId
     * @return \StructType\BudgetItem
     */
    public function setRFPId($rFPId = null)
    {
        // validation for constraint: string
        if (!is_null($rFPId) && !is_string($rFPId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPId, true), gettype($rFPId)), __LINE__);
        }
        $this->RFPId = $rFPId;
        return $this;
    }
    /**
     * Get RFPCode value
     * @return string|null
     */
    public function getRFPCode()
    {
        return $this->RFPCode;
    }
    /**
     * Set RFPCode value
     * @param string $rFPCode
     * @return \StructType\BudgetItem
     */
    public function setRFPCode($rFPCode = null)
    {
        // validation for constraint: string
        if (!is_null($rFPCode) && !is_string($rFPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPCode, true), gettype($rFPCode)), __LINE__);
        }
        $this->RFPCode = $rFPCode;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\BudgetItem
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get SubCategoryId value
     * @return string|null
     */
    public function getSubCategoryId()
    {
        return $this->SubCategoryId;
    }
    /**
     * Set SubCategoryId value
     * @param string $subCategoryId
     * @return \StructType\BudgetItem
     */
    public function setSubCategoryId($subCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($subCategoryId) && !is_string($subCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCategoryId, true), gettype($subCategoryId)), __LINE__);
        }
        $this->SubCategoryId = $subCategoryId;
        return $this;
    }
    /**
     * Get SubCategoryName value
     * @return string|null
     */
    public function getSubCategoryName()
    {
        return $this->SubCategoryName;
    }
    /**
     * Set SubCategoryName value
     * @param string $subCategoryName
     * @return \StructType\BudgetItem
     */
    public function setSubCategoryName($subCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($subCategoryName) && !is_string($subCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCategoryName, true), gettype($subCategoryName)), __LINE__);
        }
        $this->SubCategoryName = $subCategoryName;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\BudgetItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\BudgetItem
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\BudgetItem
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get VendorType value
     * @return string|null
     */
    public function getVendorType()
    {
        return $this->VendorType;
    }
    /**
     * Set VendorType value
     * @param string $vendorType
     * @return \StructType\BudgetItem
     */
    public function setVendorType($vendorType = null)
    {
        // validation for constraint: string
        if (!is_null($vendorType) && !is_string($vendorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorType, true), gettype($vendorType)), __LINE__);
        }
        $this->VendorType = $vendorType;
        return $this;
    }
    /**
     * Get VendorId value
     * @return string|null
     */
    public function getVendorId()
    {
        return $this->VendorId;
    }
    /**
     * Set VendorId value
     * @param string $vendorId
     * @return \StructType\BudgetItem
     */
    public function setVendorId($vendorId = null)
    {
        // validation for constraint: string
        if (!is_null($vendorId) && !is_string($vendorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorId, true), gettype($vendorId)), __LINE__);
        }
        $this->VendorId = $vendorId;
        return $this;
    }
    /**
     * Get VendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->VendorName;
    }
    /**
     * Set VendorName value
     * @param string $vendorName
     * @return \StructType\BudgetItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->VendorName = $vendorName;
        return $this;
    }
    /**
     * Get VendorDescription value
     * @return string|null
     */
    public function getVendorDescription()
    {
        return $this->VendorDescription;
    }
    /**
     * Set VendorDescription value
     * @param string $vendorDescription
     * @return \StructType\BudgetItem
     */
    public function setVendorDescription($vendorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($vendorDescription) && !is_string($vendorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorDescription, true), gettype($vendorDescription)), __LINE__);
        }
        $this->VendorDescription = $vendorDescription;
        return $this;
    }
    /**
     * Get VendorAddress1 value
     * @return string|null
     */
    public function getVendorAddress1()
    {
        return $this->VendorAddress1;
    }
    /**
     * Set VendorAddress1 value
     * @param string $vendorAddress1
     * @return \StructType\BudgetItem
     */
    public function setVendorAddress1($vendorAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($vendorAddress1) && !is_string($vendorAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorAddress1, true), gettype($vendorAddress1)), __LINE__);
        }
        $this->VendorAddress1 = $vendorAddress1;
        return $this;
    }
    /**
     * Get VendorAddress2 value
     * @return string|null
     */
    public function getVendorAddress2()
    {
        return $this->VendorAddress2;
    }
    /**
     * Set VendorAddress2 value
     * @param string $vendorAddress2
     * @return \StructType\BudgetItem
     */
    public function setVendorAddress2($vendorAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($vendorAddress2) && !is_string($vendorAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorAddress2, true), gettype($vendorAddress2)), __LINE__);
        }
        $this->VendorAddress2 = $vendorAddress2;
        return $this;
    }
    /**
     * Get VendorAddress3 value
     * @return string|null
     */
    public function getVendorAddress3()
    {
        return $this->VendorAddress3;
    }
    /**
     * Set VendorAddress3 value
     * @param string $vendorAddress3
     * @return \StructType\BudgetItem
     */
    public function setVendorAddress3($vendorAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($vendorAddress3) && !is_string($vendorAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorAddress3, true), gettype($vendorAddress3)), __LINE__);
        }
        $this->VendorAddress3 = $vendorAddress3;
        return $this;
    }
    /**
     * Get VendorCity value
     * @return string|null
     */
    public function getVendorCity()
    {
        return $this->VendorCity;
    }
    /**
     * Set VendorCity value
     * @param string $vendorCity
     * @return \StructType\BudgetItem
     */
    public function setVendorCity($vendorCity = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCity) && !is_string($vendorCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCity, true), gettype($vendorCity)), __LINE__);
        }
        $this->VendorCity = $vendorCity;
        return $this;
    }
    /**
     * Get VendorState value
     * @return string|null
     */
    public function getVendorState()
    {
        return $this->VendorState;
    }
    /**
     * Set VendorState value
     * @param string $vendorState
     * @return \StructType\BudgetItem
     */
    public function setVendorState($vendorState = null)
    {
        // validation for constraint: string
        if (!is_null($vendorState) && !is_string($vendorState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorState, true), gettype($vendorState)), __LINE__);
        }
        $this->VendorState = $vendorState;
        return $this;
    }
    /**
     * Get VendorPostalCode value
     * @return string|null
     */
    public function getVendorPostalCode()
    {
        return $this->VendorPostalCode;
    }
    /**
     * Set VendorPostalCode value
     * @param string $vendorPostalCode
     * @return \StructType\BudgetItem
     */
    public function setVendorPostalCode($vendorPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorPostalCode) && !is_string($vendorPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorPostalCode, true), gettype($vendorPostalCode)), __LINE__);
        }
        $this->VendorPostalCode = $vendorPostalCode;
        return $this;
    }
    /**
     * Get VendorCountry value
     * @return string|null
     */
    public function getVendorCountry()
    {
        return $this->VendorCountry;
    }
    /**
     * Set VendorCountry value
     * @param string $vendorCountry
     * @return \StructType\BudgetItem
     */
    public function setVendorCountry($vendorCountry = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCountry) && !is_string($vendorCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCountry, true), gettype($vendorCountry)), __LINE__);
        }
        $this->VendorCountry = $vendorCountry;
        return $this;
    }
    /**
     * Get VendorURL value
     * @return string|null
     */
    public function getVendorURL()
    {
        return $this->VendorURL;
    }
    /**
     * Set VendorURL value
     * @param string $vendorURL
     * @return \StructType\BudgetItem
     */
    public function setVendorURL($vendorURL = null)
    {
        // validation for constraint: string
        if (!is_null($vendorURL) && !is_string($vendorURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorURL, true), gettype($vendorURL)), __LINE__);
        }
        $this->VendorURL = $vendorURL;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\BudgetItem
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorContactFirstName value
     * @return string|null
     */
    public function getVendorContactFirstName()
    {
        return $this->VendorContactFirstName;
    }
    /**
     * Set VendorContactFirstName value
     * @param string $vendorContactFirstName
     * @return \StructType\BudgetItem
     */
    public function setVendorContactFirstName($vendorContactFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorContactFirstName) && !is_string($vendorContactFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorContactFirstName, true), gettype($vendorContactFirstName)), __LINE__);
        }
        $this->VendorContactFirstName = $vendorContactFirstName;
        return $this;
    }
    /**
     * Get VendorContactLastName value
     * @return string|null
     */
    public function getVendorContactLastName()
    {
        return $this->VendorContactLastName;
    }
    /**
     * Set VendorContactLastName value
     * @param string $vendorContactLastName
     * @return \StructType\BudgetItem
     */
    public function setVendorContactLastName($vendorContactLastName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorContactLastName) && !is_string($vendorContactLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorContactLastName, true), gettype($vendorContactLastName)), __LINE__);
        }
        $this->VendorContactLastName = $vendorContactLastName;
        return $this;
    }
    /**
     * Get VendorContactTitle value
     * @return string|null
     */
    public function getVendorContactTitle()
    {
        return $this->VendorContactTitle;
    }
    /**
     * Set VendorContactTitle value
     * @param string $vendorContactTitle
     * @return \StructType\BudgetItem
     */
    public function setVendorContactTitle($vendorContactTitle = null)
    {
        // validation for constraint: string
        if (!is_null($vendorContactTitle) && !is_string($vendorContactTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorContactTitle, true), gettype($vendorContactTitle)), __LINE__);
        }
        $this->VendorContactTitle = $vendorContactTitle;
        return $this;
    }
    /**
     * Get VendorContactPhone value
     * @return string|null
     */
    public function getVendorContactPhone()
    {
        return $this->VendorContactPhone;
    }
    /**
     * Set VendorContactPhone value
     * @param string $vendorContactPhone
     * @return \StructType\BudgetItem
     */
    public function setVendorContactPhone($vendorContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($vendorContactPhone) && !is_string($vendorContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorContactPhone, true), gettype($vendorContactPhone)), __LINE__);
        }
        $this->VendorContactPhone = $vendorContactPhone;
        return $this;
    }
    /**
     * Get VendorContactFax value
     * @return string|null
     */
    public function getVendorContactFax()
    {
        return $this->VendorContactFax;
    }
    /**
     * Set VendorContactFax value
     * @param string $vendorContactFax
     * @return \StructType\BudgetItem
     */
    public function setVendorContactFax($vendorContactFax = null)
    {
        // validation for constraint: string
        if (!is_null($vendorContactFax) && !is_string($vendorContactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorContactFax, true), gettype($vendorContactFax)), __LINE__);
        }
        $this->VendorContactFax = $vendorContactFax;
        return $this;
    }
    /**
     * Get VendorContactEmailAddress value
     * @return string|null
     */
    public function getVendorContactEmailAddress()
    {
        return $this->VendorContactEmailAddress;
    }
    /**
     * Set VendorContactEmailAddress value
     * @param string $vendorContactEmailAddress
     * @return \StructType\BudgetItem
     */
    public function setVendorContactEmailAddress($vendorContactEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($vendorContactEmailAddress) && !is_string($vendorContactEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorContactEmailAddress, true), gettype($vendorContactEmailAddress)), __LINE__);
        }
        $this->VendorContactEmailAddress = $vendorContactEmailAddress;
        return $this;
    }
    /**
     * Get VendorContactAdditionalInformation value
     * @return string|null
     */
    public function getVendorContactAdditionalInformation()
    {
        return $this->VendorContactAdditionalInformation;
    }
    /**
     * Set VendorContactAdditionalInformation value
     * @param string $vendorContactAdditionalInformation
     * @return \StructType\BudgetItem
     */
    public function setVendorContactAdditionalInformation($vendorContactAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($vendorContactAdditionalInformation) && !is_string($vendorContactAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorContactAdditionalInformation, true), gettype($vendorContactAdditionalInformation)), __LINE__);
        }
        $this->VendorContactAdditionalInformation = $vendorContactAdditionalInformation;
        return $this;
    }
    /**
     * Get GLName value
     * @return string|null
     */
    public function getGLName()
    {
        return $this->GLName;
    }
    /**
     * Set GLName value
     * @param string $gLName
     * @return \StructType\BudgetItem
     */
    public function setGLName($gLName = null)
    {
        // validation for constraint: string
        if (!is_null($gLName) && !is_string($gLName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLName, true), gettype($gLName)), __LINE__);
        }
        $this->GLName = $gLName;
        return $this;
    }
    /**
     * Get GLCode value
     * @return string|null
     */
    public function getGLCode()
    {
        return $this->GLCode;
    }
    /**
     * Set GLCode value
     * @param string $gLCode
     * @return \StructType\BudgetItem
     */
    public function setGLCode($gLCode = null)
    {
        // validation for constraint: string
        if (!is_null($gLCode) && !is_string($gLCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLCode, true), gettype($gLCode)), __LINE__);
        }
        $this->GLCode = $gLCode;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\BudgetItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\BudgetItem
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return float|null
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param float $conversionRate
     * @return \StructType\BudgetItem
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: float
        if (!is_null($conversionRate) && !(is_float($conversionRate) || is_numeric($conversionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get TaxOnGratuity value
     * @return bool|null
     */
    public function getTaxOnGratuity()
    {
        return $this->TaxOnGratuity;
    }
    /**
     * Set TaxOnGratuity value
     * @param bool $taxOnGratuity
     * @return \StructType\BudgetItem
     */
    public function setTaxOnGratuity($taxOnGratuity = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxOnGratuity) && !is_bool($taxOnGratuity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxOnGratuity, true), gettype($taxOnGratuity)), __LINE__);
        }
        $this->TaxOnGratuity = $taxOnGratuity;
        return $this;
    }
    /**
     * Get CostAvoidance value
     * @return float|null
     */
    public function getCostAvoidance()
    {
        return $this->CostAvoidance;
    }
    /**
     * Set CostAvoidance value
     * @param float $costAvoidance
     * @return \StructType\BudgetItem
     */
    public function setCostAvoidance($costAvoidance = null)
    {
        // validation for constraint: float
        if (!is_null($costAvoidance) && !(is_float($costAvoidance) || is_numeric($costAvoidance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costAvoidance, true), gettype($costAvoidance)), __LINE__);
        }
        $this->CostAvoidance = $costAvoidance;
        return $this;
    }
    /**
     * Get CostIncludesTax value
     * @return bool|null
     */
    public function getCostIncludesTax()
    {
        return $this->CostIncludesTax;
    }
    /**
     * Set CostIncludesTax value
     * @param bool $costIncludesTax
     * @return \StructType\BudgetItem
     */
    public function setCostIncludesTax($costIncludesTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($costIncludesTax) && !is_bool($costIncludesTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($costIncludesTax, true), gettype($costIncludesTax)), __LINE__);
        }
        $this->CostIncludesTax = $costIncludesTax;
        return $this;
    }
    /**
     * Get AvoidanceDescription value
     * @return string|null
     */
    public function getAvoidanceDescription()
    {
        return $this->AvoidanceDescription;
    }
    /**
     * Set AvoidanceDescription value
     * @param string $avoidanceDescription
     * @return \StructType\BudgetItem
     */
    public function setAvoidanceDescription($avoidanceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($avoidanceDescription) && !is_string($avoidanceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avoidanceDescription, true), gettype($avoidanceDescription)), __LINE__);
        }
        $this->AvoidanceDescription = $avoidanceDescription;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\BudgetItem
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\BudgetItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get ItemDate value
     * @return string|null
     */
    public function getItemDate()
    {
        return $this->ItemDate;
    }
    /**
     * Set ItemDate value
     * @param string $itemDate
     * @return \StructType\BudgetItem
     */
    public function setItemDate($itemDate = null)
    {
        // validation for constraint: string
        if (!is_null($itemDate) && !is_string($itemDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDate, true), gettype($itemDate)), __LINE__);
        }
        $this->ItemDate = $itemDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BudgetItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
