<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Budget StructType
 * @subpackage Structs
 */
class Budget extends CvObject
{
    /**
     * The CategoryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryDetail[]
     */
    public $CategoryDetail;
    /**
     * The DefaultTaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxDetail[]
     */
    public $DefaultTaxDetail;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The DefaultTax
     * @var float
     */
    public $DefaultTax;
    /**
     * The DefaultTaxType
     * @var string
     */
    public $DefaultTaxType;
    /**
     * The DefaultTax2
     * @var float
     */
    public $DefaultTax2;
    /**
     * The DefaultTax2Type
     * @var string
     */
    public $DefaultTax2Type;
    /**
     * The DefaultTax3
     * @var float
     */
    public $DefaultTax3;
    /**
     * The DefaultTax3Type
     * @var string
     */
    public $DefaultTax3Type;
    /**
     * The DefaultTax4
     * @var float
     */
    public $DefaultTax4;
    /**
     * The DefaultTax4Type
     * @var string
     */
    public $DefaultTax4Type;
    /**
     * The DefaultTax5
     * @var float
     */
    public $DefaultTax5;
    /**
     * The DefaultTax5Type
     * @var string
     */
    public $DefaultTax5Type;
    /**
     * The DefaultGratuity
     * @var float
     */
    public $DefaultGratuity;
    /**
     * The DefaultGratuityType
     * @var string
     */
    public $DefaultGratuityType;
    /**
     * The ModifiedBy
     * @var string
     */
    public $ModifiedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for Budget
     * @uses Budget::setCategoryDetail()
     * @uses Budget::setDefaultTaxDetail()
     * @uses Budget::setEventCode()
     * @uses Budget::setEventTitle()
     * @uses Budget::setDefaultTax()
     * @uses Budget::setDefaultTaxType()
     * @uses Budget::setDefaultTax2()
     * @uses Budget::setDefaultTax2Type()
     * @uses Budget::setDefaultTax3()
     * @uses Budget::setDefaultTax3Type()
     * @uses Budget::setDefaultTax4()
     * @uses Budget::setDefaultTax4Type()
     * @uses Budget::setDefaultTax5()
     * @uses Budget::setDefaultTax5Type()
     * @uses Budget::setDefaultGratuity()
     * @uses Budget::setDefaultGratuityType()
     * @uses Budget::setModifiedBy()
     * @uses Budget::setLastModifiedDate()
     * @param \StructType\CategoryDetail[] $categoryDetail
     * @param \StructType\TaxDetail[] $defaultTaxDetail
     * @param string $eventCode
     * @param string $eventTitle
     * @param float $defaultTax
     * @param string $defaultTaxType
     * @param float $defaultTax2
     * @param string $defaultTax2Type
     * @param float $defaultTax3
     * @param string $defaultTax3Type
     * @param float $defaultTax4
     * @param string $defaultTax4Type
     * @param float $defaultTax5
     * @param string $defaultTax5Type
     * @param float $defaultGratuity
     * @param string $defaultGratuityType
     * @param string $modifiedBy
     * @param string $lastModifiedDate
     */
    public function __construct(array $categoryDetail = array(), array $defaultTaxDetail = array(), $eventCode = null, $eventTitle = null, $defaultTax = null, $defaultTaxType = null, $defaultTax2 = null, $defaultTax2Type = null, $defaultTax3 = null, $defaultTax3Type = null, $defaultTax4 = null, $defaultTax4Type = null, $defaultTax5 = null, $defaultTax5Type = null, $defaultGratuity = null, $defaultGratuityType = null, $modifiedBy = null, $lastModifiedDate = null)
    {
        $this
            ->setCategoryDetail($categoryDetail)
            ->setDefaultTaxDetail($defaultTaxDetail)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setDefaultTax($defaultTax)
            ->setDefaultTaxType($defaultTaxType)
            ->setDefaultTax2($defaultTax2)
            ->setDefaultTax2Type($defaultTax2Type)
            ->setDefaultTax3($defaultTax3)
            ->setDefaultTax3Type($defaultTax3Type)
            ->setDefaultTax4($defaultTax4)
            ->setDefaultTax4Type($defaultTax4Type)
            ->setDefaultTax5($defaultTax5)
            ->setDefaultTax5Type($defaultTax5Type)
            ->setDefaultGratuity($defaultGratuity)
            ->setDefaultGratuityType($defaultGratuityType)
            ->setModifiedBy($modifiedBy)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get CategoryDetail value
     * @return \StructType\CategoryDetail[]|null
     */
    public function getCategoryDetail()
    {
        return $this->CategoryDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCategoryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategoryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryDetailForArrayConstraintsFromSetCategoryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetCategoryDetailItem) {
            // validation for constraint: itemType
            if (!$budgetCategoryDetailItem instanceof \StructType\CategoryDetail) {
                $invalidValues[] = is_object($budgetCategoryDetailItem) ? get_class($budgetCategoryDetailItem) : sprintf('%s(%s)', gettype($budgetCategoryDetailItem), var_export($budgetCategoryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CategoryDetail property can only contain items of type \StructType\CategoryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CategoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDetail[] $categoryDetail
     * @return \StructType\Budget
     */
    public function setCategoryDetail(array $categoryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryDetailArrayErrorMessage = self::validateCategoryDetailForArrayConstraintsFromSetCategoryDetail($categoryDetail))) {
            throw new \InvalidArgumentException($categoryDetailArrayErrorMessage, __LINE__);
        }
        $this->CategoryDetail = $categoryDetail;
        return $this;
    }
    /**
     * Add item to CategoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDetail $item
     * @return \StructType\Budget
     */
    public function addToCategoryDetail(\StructType\CategoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryDetail) {
            throw new \InvalidArgumentException(sprintf('The CategoryDetail property can only contain items of type \StructType\CategoryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CategoryDetail[] = $item;
        return $this;
    }
    /**
     * Get DefaultTaxDetail value
     * @return \StructType\TaxDetail[]|null
     */
    public function getDefaultTaxDetail()
    {
        return $this->DefaultTaxDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDefaultTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefaultTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefaultTaxDetailForArrayConstraintsFromSetDefaultTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetDefaultTaxDetailItem) {
            // validation for constraint: itemType
            if (!$budgetDefaultTaxDetailItem instanceof \StructType\TaxDetail) {
                $invalidValues[] = is_object($budgetDefaultTaxDetailItem) ? get_class($budgetDefaultTaxDetailItem) : sprintf('%s(%s)', gettype($budgetDefaultTaxDetailItem), var_export($budgetDefaultTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DefaultTaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DefaultTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail[] $defaultTaxDetail
     * @return \StructType\Budget
     */
    public function setDefaultTaxDetail(array $defaultTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($defaultTaxDetailArrayErrorMessage = self::validateDefaultTaxDetailForArrayConstraintsFromSetDefaultTaxDetail($defaultTaxDetail))) {
            throw new \InvalidArgumentException($defaultTaxDetailArrayErrorMessage, __LINE__);
        }
        $this->DefaultTaxDetail = $defaultTaxDetail;
        return $this;
    }
    /**
     * Add item to DefaultTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail $item
     * @return \StructType\Budget
     */
    public function addToDefaultTaxDetail(\StructType\TaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxDetail) {
            throw new \InvalidArgumentException(sprintf('The DefaultTaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DefaultTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Budget
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Budget
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get DefaultTax value
     * @return float|null
     */
    public function getDefaultTax()
    {
        return $this->DefaultTax;
    }
    /**
     * Set DefaultTax value
     * @param float $defaultTax
     * @return \StructType\Budget
     */
    public function setDefaultTax($defaultTax = null)
    {
        // validation for constraint: float
        if (!is_null($defaultTax) && !(is_float($defaultTax) || is_numeric($defaultTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultTax, true), gettype($defaultTax)), __LINE__);
        }
        $this->DefaultTax = $defaultTax;
        return $this;
    }
    /**
     * Get DefaultTaxType value
     * @return string|null
     */
    public function getDefaultTaxType()
    {
        return $this->DefaultTaxType;
    }
    /**
     * Set DefaultTaxType value
     * @param string $defaultTaxType
     * @return \StructType\Budget
     */
    public function setDefaultTaxType($defaultTaxType = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTaxType) && !is_string($defaultTaxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTaxType, true), gettype($defaultTaxType)), __LINE__);
        }
        $this->DefaultTaxType = $defaultTaxType;
        return $this;
    }
    /**
     * Get DefaultTax2 value
     * @return float|null
     */
    public function getDefaultTax2()
    {
        return $this->DefaultTax2;
    }
    /**
     * Set DefaultTax2 value
     * @param float $defaultTax2
     * @return \StructType\Budget
     */
    public function setDefaultTax2($defaultTax2 = null)
    {
        // validation for constraint: float
        if (!is_null($defaultTax2) && !(is_float($defaultTax2) || is_numeric($defaultTax2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultTax2, true), gettype($defaultTax2)), __LINE__);
        }
        $this->DefaultTax2 = $defaultTax2;
        return $this;
    }
    /**
     * Get DefaultTax2Type value
     * @return string|null
     */
    public function getDefaultTax2Type()
    {
        return $this->DefaultTax2Type;
    }
    /**
     * Set DefaultTax2Type value
     * @param string $defaultTax2Type
     * @return \StructType\Budget
     */
    public function setDefaultTax2Type($defaultTax2Type = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTax2Type) && !is_string($defaultTax2Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTax2Type, true), gettype($defaultTax2Type)), __LINE__);
        }
        $this->DefaultTax2Type = $defaultTax2Type;
        return $this;
    }
    /**
     * Get DefaultTax3 value
     * @return float|null
     */
    public function getDefaultTax3()
    {
        return $this->DefaultTax3;
    }
    /**
     * Set DefaultTax3 value
     * @param float $defaultTax3
     * @return \StructType\Budget
     */
    public function setDefaultTax3($defaultTax3 = null)
    {
        // validation for constraint: float
        if (!is_null($defaultTax3) && !(is_float($defaultTax3) || is_numeric($defaultTax3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultTax3, true), gettype($defaultTax3)), __LINE__);
        }
        $this->DefaultTax3 = $defaultTax3;
        return $this;
    }
    /**
     * Get DefaultTax3Type value
     * @return string|null
     */
    public function getDefaultTax3Type()
    {
        return $this->DefaultTax3Type;
    }
    /**
     * Set DefaultTax3Type value
     * @param string $defaultTax3Type
     * @return \StructType\Budget
     */
    public function setDefaultTax3Type($defaultTax3Type = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTax3Type) && !is_string($defaultTax3Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTax3Type, true), gettype($defaultTax3Type)), __LINE__);
        }
        $this->DefaultTax3Type = $defaultTax3Type;
        return $this;
    }
    /**
     * Get DefaultTax4 value
     * @return float|null
     */
    public function getDefaultTax4()
    {
        return $this->DefaultTax4;
    }
    /**
     * Set DefaultTax4 value
     * @param float $defaultTax4
     * @return \StructType\Budget
     */
    public function setDefaultTax4($defaultTax4 = null)
    {
        // validation for constraint: float
        if (!is_null($defaultTax4) && !(is_float($defaultTax4) || is_numeric($defaultTax4))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultTax4, true), gettype($defaultTax4)), __LINE__);
        }
        $this->DefaultTax4 = $defaultTax4;
        return $this;
    }
    /**
     * Get DefaultTax4Type value
     * @return string|null
     */
    public function getDefaultTax4Type()
    {
        return $this->DefaultTax4Type;
    }
    /**
     * Set DefaultTax4Type value
     * @param string $defaultTax4Type
     * @return \StructType\Budget
     */
    public function setDefaultTax4Type($defaultTax4Type = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTax4Type) && !is_string($defaultTax4Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTax4Type, true), gettype($defaultTax4Type)), __LINE__);
        }
        $this->DefaultTax4Type = $defaultTax4Type;
        return $this;
    }
    /**
     * Get DefaultTax5 value
     * @return float|null
     */
    public function getDefaultTax5()
    {
        return $this->DefaultTax5;
    }
    /**
     * Set DefaultTax5 value
     * @param float $defaultTax5
     * @return \StructType\Budget
     */
    public function setDefaultTax5($defaultTax5 = null)
    {
        // validation for constraint: float
        if (!is_null($defaultTax5) && !(is_float($defaultTax5) || is_numeric($defaultTax5))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultTax5, true), gettype($defaultTax5)), __LINE__);
        }
        $this->DefaultTax5 = $defaultTax5;
        return $this;
    }
    /**
     * Get DefaultTax5Type value
     * @return string|null
     */
    public function getDefaultTax5Type()
    {
        return $this->DefaultTax5Type;
    }
    /**
     * Set DefaultTax5Type value
     * @param string $defaultTax5Type
     * @return \StructType\Budget
     */
    public function setDefaultTax5Type($defaultTax5Type = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTax5Type) && !is_string($defaultTax5Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTax5Type, true), gettype($defaultTax5Type)), __LINE__);
        }
        $this->DefaultTax5Type = $defaultTax5Type;
        return $this;
    }
    /**
     * Get DefaultGratuity value
     * @return float|null
     */
    public function getDefaultGratuity()
    {
        return $this->DefaultGratuity;
    }
    /**
     * Set DefaultGratuity value
     * @param float $defaultGratuity
     * @return \StructType\Budget
     */
    public function setDefaultGratuity($defaultGratuity = null)
    {
        // validation for constraint: float
        if (!is_null($defaultGratuity) && !(is_float($defaultGratuity) || is_numeric($defaultGratuity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultGratuity, true), gettype($defaultGratuity)), __LINE__);
        }
        $this->DefaultGratuity = $defaultGratuity;
        return $this;
    }
    /**
     * Get DefaultGratuityType value
     * @return string|null
     */
    public function getDefaultGratuityType()
    {
        return $this->DefaultGratuityType;
    }
    /**
     * Set DefaultGratuityType value
     * @param string $defaultGratuityType
     * @return \StructType\Budget
     */
    public function setDefaultGratuityType($defaultGratuityType = null)
    {
        // validation for constraint: string
        if (!is_null($defaultGratuityType) && !is_string($defaultGratuityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultGratuityType, true), gettype($defaultGratuityType)), __LINE__);
        }
        $this->DefaultGratuityType = $defaultGratuityType;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return string|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param string $modifiedBy
     * @return \StructType\Budget
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedBy) && !is_string($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedBy, true), gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Budget
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Budget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
