<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRFPEventInfo StructType
 * @subpackage Structs
 */
class BaseRFPEventInfo extends AbstractStructBase
{
    /**
     * The EventName
     * @var string
     */
    public $EventName;
    /**
     * The EventType
     * @var string
     */
    public $EventType;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * @var string
     */
    public $EventEndDate;
    /**
     * The TotalAttendees
     * @var int
     */
    public $TotalAttendees;
    /**
     * The RepeatEvent
     * @var bool
     */
    public $RepeatEvent;
    /**
     * The TotalBudget
     * @var float
     */
    public $TotalBudget;
    /**
     * The TotalMeetingSpace
     * @var int
     */
    public $TotalMeetingSpace;
    /**
     * The AlternateStartDate1
     * @var string
     */
    public $AlternateStartDate1;
    /**
     * The AlternateEndDate1
     * @var string
     */
    public $AlternateEndDate1;
    /**
     * The AlternateStartDate2
     * @var string
     */
    public $AlternateStartDate2;
    /**
     * The AlternateEndDate2
     * @var string
     */
    public $AlternateEndDate2;
    /**
     * The LargestMeetingRoom
     * @var int
     */
    public $LargestMeetingRoom;
    /**
     * The ContractSignatureLocation
     * @var string
     */
    public $ContractSignatureLocation;
    /**
     * The BusinessObjectives
     * @var string
     */
    public $BusinessObjectives;
    /**
     * The DestinationsUnderConsideration
     * @var string
     */
    public $DestinationsUnderConsideration;
    /**
     * The AdditionalInformation
     * @var string
     */
    public $AdditionalInformation;
    /**
     * The Concessions
     * @var string
     */
    public $Concessions;
    /**
     * The BillingInformation
     * @var string
     */
    public $BillingInformation;
    /**
     * The FlexibleDates
     * @var bool
     */
    public $FlexibleDates;
    /**
     * Constructor method for BaseRFPEventInfo
     * @uses BaseRFPEventInfo::setEventName()
     * @uses BaseRFPEventInfo::setEventType()
     * @uses BaseRFPEventInfo::setReferenceNumber()
     * @uses BaseRFPEventInfo::setEventStartDate()
     * @uses BaseRFPEventInfo::setEventEndDate()
     * @uses BaseRFPEventInfo::setTotalAttendees()
     * @uses BaseRFPEventInfo::setRepeatEvent()
     * @uses BaseRFPEventInfo::setTotalBudget()
     * @uses BaseRFPEventInfo::setTotalMeetingSpace()
     * @uses BaseRFPEventInfo::setAlternateStartDate1()
     * @uses BaseRFPEventInfo::setAlternateEndDate1()
     * @uses BaseRFPEventInfo::setAlternateStartDate2()
     * @uses BaseRFPEventInfo::setAlternateEndDate2()
     * @uses BaseRFPEventInfo::setLargestMeetingRoom()
     * @uses BaseRFPEventInfo::setContractSignatureLocation()
     * @uses BaseRFPEventInfo::setBusinessObjectives()
     * @uses BaseRFPEventInfo::setDestinationsUnderConsideration()
     * @uses BaseRFPEventInfo::setAdditionalInformation()
     * @uses BaseRFPEventInfo::setConcessions()
     * @uses BaseRFPEventInfo::setBillingInformation()
     * @uses BaseRFPEventInfo::setFlexibleDates()
     * @param string $eventName
     * @param string $eventType
     * @param string $referenceNumber
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param int $totalAttendees
     * @param bool $repeatEvent
     * @param float $totalBudget
     * @param int $totalMeetingSpace
     * @param string $alternateStartDate1
     * @param string $alternateEndDate1
     * @param string $alternateStartDate2
     * @param string $alternateEndDate2
     * @param int $largestMeetingRoom
     * @param string $contractSignatureLocation
     * @param string $businessObjectives
     * @param string $destinationsUnderConsideration
     * @param string $additionalInformation
     * @param string $concessions
     * @param string $billingInformation
     * @param bool $flexibleDates
     */
    public function __construct($eventName = null, $eventType = null, $referenceNumber = null, $eventStartDate = null, $eventEndDate = null, $totalAttendees = null, $repeatEvent = null, $totalBudget = null, $totalMeetingSpace = null, $alternateStartDate1 = null, $alternateEndDate1 = null, $alternateStartDate2 = null, $alternateEndDate2 = null, $largestMeetingRoom = null, $contractSignatureLocation = null, $businessObjectives = null, $destinationsUnderConsideration = null, $additionalInformation = null, $concessions = null, $billingInformation = null, $flexibleDates = null)
    {
        $this
            ->setEventName($eventName)
            ->setEventType($eventType)
            ->setReferenceNumber($referenceNumber)
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setTotalAttendees($totalAttendees)
            ->setRepeatEvent($repeatEvent)
            ->setTotalBudget($totalBudget)
            ->setTotalMeetingSpace($totalMeetingSpace)
            ->setAlternateStartDate1($alternateStartDate1)
            ->setAlternateEndDate1($alternateEndDate1)
            ->setAlternateStartDate2($alternateStartDate2)
            ->setAlternateEndDate2($alternateEndDate2)
            ->setLargestMeetingRoom($largestMeetingRoom)
            ->setContractSignatureLocation($contractSignatureLocation)
            ->setBusinessObjectives($businessObjectives)
            ->setDestinationsUnderConsideration($destinationsUnderConsideration)
            ->setAdditionalInformation($additionalInformation)
            ->setConcessions($concessions)
            ->setBillingInformation($billingInformation)
            ->setFlexibleDates($flexibleDates);
    }
    /**
     * Get EventName value
     * @return string|null
     */
    public function getEventName()
    {
        return $this->EventName;
    }
    /**
     * Set EventName value
     * @param string $eventName
     * @return \StructType\BaseRFPEventInfo
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        $this->EventName = $eventName;
        return $this;
    }
    /**
     * Get EventType value
     * @return string|null
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @param string $eventType
     * @return \StructType\BaseRFPEventInfo
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: string
        if (!is_null($eventType) && !is_string($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType, true), gettype($eventType)), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\BaseRFPEventInfo
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\BaseRFPEventInfo
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \StructType\BaseRFPEventInfo
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get TotalAttendees value
     * @return int|null
     */
    public function getTotalAttendees()
    {
        return $this->TotalAttendees;
    }
    /**
     * Set TotalAttendees value
     * @param int $totalAttendees
     * @return \StructType\BaseRFPEventInfo
     */
    public function setTotalAttendees($totalAttendees = null)
    {
        // validation for constraint: int
        if (!is_null($totalAttendees) && !(is_int($totalAttendees) || ctype_digit($totalAttendees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAttendees, true), gettype($totalAttendees)), __LINE__);
        }
        $this->TotalAttendees = $totalAttendees;
        return $this;
    }
    /**
     * Get RepeatEvent value
     * @return bool|null
     */
    public function getRepeatEvent()
    {
        return $this->RepeatEvent;
    }
    /**
     * Set RepeatEvent value
     * @param bool $repeatEvent
     * @return \StructType\BaseRFPEventInfo
     */
    public function setRepeatEvent($repeatEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($repeatEvent) && !is_bool($repeatEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($repeatEvent, true), gettype($repeatEvent)), __LINE__);
        }
        $this->RepeatEvent = $repeatEvent;
        return $this;
    }
    /**
     * Get TotalBudget value
     * @return float|null
     */
    public function getTotalBudget()
    {
        return $this->TotalBudget;
    }
    /**
     * Set TotalBudget value
     * @param float $totalBudget
     * @return \StructType\BaseRFPEventInfo
     */
    public function setTotalBudget($totalBudget = null)
    {
        // validation for constraint: float
        if (!is_null($totalBudget) && !(is_float($totalBudget) || is_numeric($totalBudget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalBudget, true), gettype($totalBudget)), __LINE__);
        }
        $this->TotalBudget = $totalBudget;
        return $this;
    }
    /**
     * Get TotalMeetingSpace value
     * @return int|null
     */
    public function getTotalMeetingSpace()
    {
        return $this->TotalMeetingSpace;
    }
    /**
     * Set TotalMeetingSpace value
     * @param int $totalMeetingSpace
     * @return \StructType\BaseRFPEventInfo
     */
    public function setTotalMeetingSpace($totalMeetingSpace = null)
    {
        // validation for constraint: int
        if (!is_null($totalMeetingSpace) && !(is_int($totalMeetingSpace) || ctype_digit($totalMeetingSpace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMeetingSpace, true), gettype($totalMeetingSpace)), __LINE__);
        }
        $this->TotalMeetingSpace = $totalMeetingSpace;
        return $this;
    }
    /**
     * Get AlternateStartDate1 value
     * @return string|null
     */
    public function getAlternateStartDate1()
    {
        return $this->AlternateStartDate1;
    }
    /**
     * Set AlternateStartDate1 value
     * @param string $alternateStartDate1
     * @return \StructType\BaseRFPEventInfo
     */
    public function setAlternateStartDate1($alternateStartDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateStartDate1) && !is_string($alternateStartDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateStartDate1, true), gettype($alternateStartDate1)), __LINE__);
        }
        $this->AlternateStartDate1 = $alternateStartDate1;
        return $this;
    }
    /**
     * Get AlternateEndDate1 value
     * @return string|null
     */
    public function getAlternateEndDate1()
    {
        return $this->AlternateEndDate1;
    }
    /**
     * Set AlternateEndDate1 value
     * @param string $alternateEndDate1
     * @return \StructType\BaseRFPEventInfo
     */
    public function setAlternateEndDate1($alternateEndDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateEndDate1) && !is_string($alternateEndDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateEndDate1, true), gettype($alternateEndDate1)), __LINE__);
        }
        $this->AlternateEndDate1 = $alternateEndDate1;
        return $this;
    }
    /**
     * Get AlternateStartDate2 value
     * @return string|null
     */
    public function getAlternateStartDate2()
    {
        return $this->AlternateStartDate2;
    }
    /**
     * Set AlternateStartDate2 value
     * @param string $alternateStartDate2
     * @return \StructType\BaseRFPEventInfo
     */
    public function setAlternateStartDate2($alternateStartDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateStartDate2) && !is_string($alternateStartDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateStartDate2, true), gettype($alternateStartDate2)), __LINE__);
        }
        $this->AlternateStartDate2 = $alternateStartDate2;
        return $this;
    }
    /**
     * Get AlternateEndDate2 value
     * @return string|null
     */
    public function getAlternateEndDate2()
    {
        return $this->AlternateEndDate2;
    }
    /**
     * Set AlternateEndDate2 value
     * @param string $alternateEndDate2
     * @return \StructType\BaseRFPEventInfo
     */
    public function setAlternateEndDate2($alternateEndDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateEndDate2) && !is_string($alternateEndDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateEndDate2, true), gettype($alternateEndDate2)), __LINE__);
        }
        $this->AlternateEndDate2 = $alternateEndDate2;
        return $this;
    }
    /**
     * Get LargestMeetingRoom value
     * @return int|null
     */
    public function getLargestMeetingRoom()
    {
        return $this->LargestMeetingRoom;
    }
    /**
     * Set LargestMeetingRoom value
     * @param int $largestMeetingRoom
     * @return \StructType\BaseRFPEventInfo
     */
    public function setLargestMeetingRoom($largestMeetingRoom = null)
    {
        // validation for constraint: int
        if (!is_null($largestMeetingRoom) && !(is_int($largestMeetingRoom) || ctype_digit($largestMeetingRoom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largestMeetingRoom, true), gettype($largestMeetingRoom)), __LINE__);
        }
        $this->LargestMeetingRoom = $largestMeetingRoom;
        return $this;
    }
    /**
     * Get ContractSignatureLocation value
     * @return string|null
     */
    public function getContractSignatureLocation()
    {
        return $this->ContractSignatureLocation;
    }
    /**
     * Set ContractSignatureLocation value
     * @param string $contractSignatureLocation
     * @return \StructType\BaseRFPEventInfo
     */
    public function setContractSignatureLocation($contractSignatureLocation = null)
    {
        // validation for constraint: string
        if (!is_null($contractSignatureLocation) && !is_string($contractSignatureLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractSignatureLocation, true), gettype($contractSignatureLocation)), __LINE__);
        }
        $this->ContractSignatureLocation = $contractSignatureLocation;
        return $this;
    }
    /**
     * Get BusinessObjectives value
     * @return string|null
     */
    public function getBusinessObjectives()
    {
        return $this->BusinessObjectives;
    }
    /**
     * Set BusinessObjectives value
     * @param string $businessObjectives
     * @return \StructType\BaseRFPEventInfo
     */
    public function setBusinessObjectives($businessObjectives = null)
    {
        // validation for constraint: string
        if (!is_null($businessObjectives) && !is_string($businessObjectives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessObjectives, true), gettype($businessObjectives)), __LINE__);
        }
        $this->BusinessObjectives = $businessObjectives;
        return $this;
    }
    /**
     * Get DestinationsUnderConsideration value
     * @return string|null
     */
    public function getDestinationsUnderConsideration()
    {
        return $this->DestinationsUnderConsideration;
    }
    /**
     * Set DestinationsUnderConsideration value
     * @param string $destinationsUnderConsideration
     * @return \StructType\BaseRFPEventInfo
     */
    public function setDestinationsUnderConsideration($destinationsUnderConsideration = null)
    {
        // validation for constraint: string
        if (!is_null($destinationsUnderConsideration) && !is_string($destinationsUnderConsideration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationsUnderConsideration, true), gettype($destinationsUnderConsideration)), __LINE__);
        }
        $this->DestinationsUnderConsideration = $destinationsUnderConsideration;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return string|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param string $additionalInformation
     * @return \StructType\BaseRFPEventInfo
     */
    public function setAdditionalInformation($additionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformation) && !is_string($additionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformation, true), gettype($additionalInformation)), __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get Concessions value
     * @return string|null
     */
    public function getConcessions()
    {
        return $this->Concessions;
    }
    /**
     * Set Concessions value
     * @param string $concessions
     * @return \StructType\BaseRFPEventInfo
     */
    public function setConcessions($concessions = null)
    {
        // validation for constraint: string
        if (!is_null($concessions) && !is_string($concessions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($concessions, true), gettype($concessions)), __LINE__);
        }
        $this->Concessions = $concessions;
        return $this;
    }
    /**
     * Get BillingInformation value
     * @return string|null
     */
    public function getBillingInformation()
    {
        return $this->BillingInformation;
    }
    /**
     * Set BillingInformation value
     * @param string $billingInformation
     * @return \StructType\BaseRFPEventInfo
     */
    public function setBillingInformation($billingInformation = null)
    {
        // validation for constraint: string
        if (!is_null($billingInformation) && !is_string($billingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingInformation, true), gettype($billingInformation)), __LINE__);
        }
        $this->BillingInformation = $billingInformation;
        return $this;
    }
    /**
     * Get FlexibleDates value
     * @return bool|null
     */
    public function getFlexibleDates()
    {
        return $this->FlexibleDates;
    }
    /**
     * Set FlexibleDates value
     * @param bool $flexibleDates
     * @return \StructType\BaseRFPEventInfo
     */
    public function setFlexibleDates($flexibleDates = null)
    {
        // validation for constraint: boolean
        if (!is_null($flexibleDates) && !is_bool($flexibleDates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flexibleDates, true), gettype($flexibleDates)), __LINE__);
        }
        $this->FlexibleDates = $flexibleDates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseRFPEventInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
