<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRFPEventHistoryDetail StructType
 * @subpackage Structs
 */
class BaseRFPEventHistoryDetail extends AbstractStructBase
{
    /**
     * The VenueName
     * @var string
     */
    public $VenueName;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The State
     * @var string
     */
    public $State;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Attendees
     * @var int
     */
    public $Attendees;
    /**
     * The RoomBlock
     * @var int
     */
    public $RoomBlock;
    /**
     * The RoomPickup
     * @var int
     */
    public $RoomPickup;
    /**
     * Constructor method for BaseRFPEventHistoryDetail
     * @uses BaseRFPEventHistoryDetail::setVenueName()
     * @uses BaseRFPEventHistoryDetail::setCity()
     * @uses BaseRFPEventHistoryDetail::setState()
     * @uses BaseRFPEventHistoryDetail::setStateCode()
     * @uses BaseRFPEventHistoryDetail::setDate()
     * @uses BaseRFPEventHistoryDetail::setAttendees()
     * @uses BaseRFPEventHistoryDetail::setRoomBlock()
     * @uses BaseRFPEventHistoryDetail::setRoomPickup()
     * @param string $venueName
     * @param string $city
     * @param string $state
     * @param string $stateCode
     * @param string $date
     * @param int $attendees
     * @param int $roomBlock
     * @param int $roomPickup
     */
    public function __construct($venueName = null, $city = null, $state = null, $stateCode = null, $date = null, $attendees = null, $roomBlock = null, $roomPickup = null)
    {
        $this
            ->setVenueName($venueName)
            ->setCity($city)
            ->setState($state)
            ->setStateCode($stateCode)
            ->setDate($date)
            ->setAttendees($attendees)
            ->setRoomBlock($roomBlock)
            ->setRoomPickup($roomPickup);
    }
    /**
     * Get VenueName value
     * @return string|null
     */
    public function getVenueName()
    {
        return $this->VenueName;
    }
    /**
     * Set VenueName value
     * @param string $venueName
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        $this->VenueName = $venueName;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Attendees value
     * @return int|null
     */
    public function getAttendees()
    {
        return $this->Attendees;
    }
    /**
     * Set Attendees value
     * @param int $attendees
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setAttendees($attendees = null)
    {
        // validation for constraint: int
        if (!is_null($attendees) && !(is_int($attendees) || ctype_digit($attendees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attendees, true), gettype($attendees)), __LINE__);
        }
        $this->Attendees = $attendees;
        return $this;
    }
    /**
     * Get RoomBlock value
     * @return int|null
     */
    public function getRoomBlock()
    {
        return $this->RoomBlock;
    }
    /**
     * Set RoomBlock value
     * @param int $roomBlock
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setRoomBlock($roomBlock = null)
    {
        // validation for constraint: int
        if (!is_null($roomBlock) && !(is_int($roomBlock) || ctype_digit($roomBlock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomBlock, true), gettype($roomBlock)), __LINE__);
        }
        $this->RoomBlock = $roomBlock;
        return $this;
    }
    /**
     * Get RoomPickup value
     * @return int|null
     */
    public function getRoomPickup()
    {
        return $this->RoomPickup;
    }
    /**
     * Set RoomPickup value
     * @param int $roomPickup
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public function setRoomPickup($roomPickup = null)
    {
        // validation for constraint: int
        if (!is_null($roomPickup) && !(is_int($roomPickup) || ctype_digit($roomPickup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomPickup, true), gettype($roomPickup)), __LINE__);
        }
        $this->RoomPickup = $roomPickup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseRFPEventHistoryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
