<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentDetail StructType
 * @subpackage Structs
 */
class AttachmentDetail extends AbstractStructBase
{
    /**
     * The FileName
     * @var string
     */
    public $FileName;
    /**
     * The FileType
     * @var string
     */
    public $FileType;
    /**
     * The FileSize
     * @var int
     */
    public $FileSize;
    /**
     * The UploadedDate
     * @var string
     */
    public $UploadedDate;
    /**
     * The FileUrl
     * @var string
     */
    public $FileUrl;
    /**
     * Constructor method for AttachmentDetail
     * @uses AttachmentDetail::setFileName()
     * @uses AttachmentDetail::setFileType()
     * @uses AttachmentDetail::setFileSize()
     * @uses AttachmentDetail::setUploadedDate()
     * @uses AttachmentDetail::setFileUrl()
     * @param string $fileName
     * @param string $fileType
     * @param int $fileSize
     * @param string $uploadedDate
     * @param string $fileUrl
     */
    public function __construct($fileName = null, $fileType = null, $fileSize = null, $uploadedDate = null, $fileUrl = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileType($fileType)
            ->setFileSize($fileSize)
            ->setUploadedDate($uploadedDate)
            ->setFileUrl($fileUrl);
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\AttachmentDetail
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @param string $fileType
     * @return \StructType\AttachmentDetail
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\AttachmentDetail
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get UploadedDate value
     * @return string|null
     */
    public function getUploadedDate()
    {
        return $this->UploadedDate;
    }
    /**
     * Set UploadedDate value
     * @param string $uploadedDate
     * @return \StructType\AttachmentDetail
     */
    public function setUploadedDate($uploadedDate = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedDate) && !is_string($uploadedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedDate, true), gettype($uploadedDate)), __LINE__);
        }
        $this->UploadedDate = $uploadedDate;
        return $this;
    }
    /**
     * Get FileUrl value
     * @return string|null
     */
    public function getFileUrl()
    {
        return $this->FileUrl;
    }
    /**
     * Set FileUrl value
     * @param string $fileUrl
     * @return \StructType\AttachmentDetail
     */
    public function setFileUrl($fileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($fileUrl) && !is_string($fileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileUrl, true), gettype($fileUrl)), __LINE__);
        }
        $this->FileUrl = $fileUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
