<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociatedRegistrants StructType
 * @subpackage Structs
 */
class AssociatedRegistrants extends AbstractStructBase
{
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The InviteeId
     * @var string
     */
    public $InviteeId;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * Constructor method for AssociatedRegistrants
     * @uses AssociatedRegistrants::setFirstName()
     * @uses AssociatedRegistrants::setLastName()
     * @uses AssociatedRegistrants::setInviteeId()
     * @uses AssociatedRegistrants::setContactId()
     * @param string $firstName
     * @param string $lastName
     * @param string $inviteeId
     * @param string $contactId
     */
    public function __construct($firstName = null, $lastName = null, $inviteeId = null, $contactId = null)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setInviteeId($inviteeId)
            ->setContactId($contactId);
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AssociatedRegistrants
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\AssociatedRegistrants
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get InviteeId value
     * @return string|null
     */
    public function getInviteeId()
    {
        return $this->InviteeId;
    }
    /**
     * Set InviteeId value
     * @param string $inviteeId
     * @return \StructType\AssociatedRegistrants
     */
    public function setInviteeId($inviteeId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeId) && !is_string($inviteeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeId, true), gettype($inviteeId)), __LINE__);
        }
        $this->InviteeId = $inviteeId;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\AssociatedRegistrants
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociatedRegistrants
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
