<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssignedSessions StructType
 * @subpackage Structs
 */
class AssignedSessions extends AbstractStructBase
{
    /**
     * The SessionId
     * @var string
     */
    public $SessionId;
    /**
     * The SessionName
     * @var string
     */
    public $SessionName;
    /**
     * The SessionStartDate
     * @var string
     */
    public $SessionStartDate;
    /**
     * The SessionEndDate
     * @var string
     */
    public $SessionEndDate;
    /**
     * Constructor method for AssignedSessions
     * @uses AssignedSessions::setSessionId()
     * @uses AssignedSessions::setSessionName()
     * @uses AssignedSessions::setSessionStartDate()
     * @uses AssignedSessions::setSessionEndDate()
     * @param string $sessionId
     * @param string $sessionName
     * @param string $sessionStartDate
     * @param string $sessionEndDate
     */
    public function __construct($sessionId = null, $sessionName = null, $sessionStartDate = null, $sessionEndDate = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setSessionName($sessionName)
            ->setSessionStartDate($sessionStartDate)
            ->setSessionEndDate($sessionEndDate);
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \StructType\AssignedSessions
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get SessionName value
     * @return string|null
     */
    public function getSessionName()
    {
        return $this->SessionName;
    }
    /**
     * Set SessionName value
     * @param string $sessionName
     * @return \StructType\AssignedSessions
     */
    public function setSessionName($sessionName = null)
    {
        // validation for constraint: string
        if (!is_null($sessionName) && !is_string($sessionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionName, true), gettype($sessionName)), __LINE__);
        }
        $this->SessionName = $sessionName;
        return $this;
    }
    /**
     * Get SessionStartDate value
     * @return string|null
     */
    public function getSessionStartDate()
    {
        return $this->SessionStartDate;
    }
    /**
     * Set SessionStartDate value
     * @param string $sessionStartDate
     * @return \StructType\AssignedSessions
     */
    public function setSessionStartDate($sessionStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($sessionStartDate) && !is_string($sessionStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionStartDate, true), gettype($sessionStartDate)), __LINE__);
        }
        $this->SessionStartDate = $sessionStartDate;
        return $this;
    }
    /**
     * Get SessionEndDate value
     * @return string|null
     */
    public function getSessionEndDate()
    {
        return $this->SessionEndDate;
    }
    /**
     * Set SessionEndDate value
     * @param string $sessionEndDate
     * @return \StructType\AssignedSessions
     */
    public function setSessionEndDate($sessionEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($sessionEndDate) && !is_string($sessionEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionEndDate, true), gettype($sessionEndDate)), __LINE__);
        }
        $this->SessionEndDate = $sessionEndDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssignedSessions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
