<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Approver StructType
 * @subpackage Structs
 */
class Approver extends CvObject
{
    /**
     * The ApproverCategoryID
     * @var string
     */
    public $ApproverCategoryID;
    /**
     * The ApproverCategory
     * @var string
     */
    public $ApproverCategory;
    /**
     * The RequestorSourceValue
     * @var string
     */
    public $RequestorSourceValue;
    /**
     * The ApproverEmail
     * @var string
     */
    public $ApproverEmail;
    /**
     * Constructor method for Approver
     * @uses Approver::setApproverCategoryID()
     * @uses Approver::setApproverCategory()
     * @uses Approver::setRequestorSourceValue()
     * @uses Approver::setApproverEmail()
     * @param string $approverCategoryID
     * @param string $approverCategory
     * @param string $requestorSourceValue
     * @param string $approverEmail
     */
    public function __construct($approverCategoryID = null, $approverCategory = null, $requestorSourceValue = null, $approverEmail = null)
    {
        $this
            ->setApproverCategoryID($approverCategoryID)
            ->setApproverCategory($approverCategory)
            ->setRequestorSourceValue($requestorSourceValue)
            ->setApproverEmail($approverEmail);
    }
    /**
     * Get ApproverCategoryID value
     * @return string|null
     */
    public function getApproverCategoryID()
    {
        return $this->ApproverCategoryID;
    }
    /**
     * Set ApproverCategoryID value
     * @param string $approverCategoryID
     * @return \StructType\Approver
     */
    public function setApproverCategoryID($approverCategoryID = null)
    {
        // validation for constraint: string
        if (!is_null($approverCategoryID) && !is_string($approverCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approverCategoryID, true), gettype($approverCategoryID)), __LINE__);
        }
        $this->ApproverCategoryID = $approverCategoryID;
        return $this;
    }
    /**
     * Get ApproverCategory value
     * @return string|null
     */
    public function getApproverCategory()
    {
        return $this->ApproverCategory;
    }
    /**
     * Set ApproverCategory value
     * @param string $approverCategory
     * @return \StructType\Approver
     */
    public function setApproverCategory($approverCategory = null)
    {
        // validation for constraint: string
        if (!is_null($approverCategory) && !is_string($approverCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approverCategory, true), gettype($approverCategory)), __LINE__);
        }
        $this->ApproverCategory = $approverCategory;
        return $this;
    }
    /**
     * Get RequestorSourceValue value
     * @return string|null
     */
    public function getRequestorSourceValue()
    {
        return $this->RequestorSourceValue;
    }
    /**
     * Set RequestorSourceValue value
     * @param string $requestorSourceValue
     * @return \StructType\Approver
     */
    public function setRequestorSourceValue($requestorSourceValue = null)
    {
        // validation for constraint: string
        if (!is_null($requestorSourceValue) && !is_string($requestorSourceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorSourceValue, true), gettype($requestorSourceValue)), __LINE__);
        }
        $this->RequestorSourceValue = $requestorSourceValue;
        return $this;
    }
    /**
     * Get ApproverEmail value
     * @return string|null
     */
    public function getApproverEmail()
    {
        return $this->ApproverEmail;
    }
    /**
     * Set ApproverEmail value
     * @param string $approverEmail
     * @return \StructType\Approver
     */
    public function setApproverEmail($approverEmail = null)
    {
        // validation for constraint: string
        if (!is_null($approverEmail) && !is_string($approverEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approverEmail, true), gettype($approverEmail)), __LINE__);
        }
        $this->ApproverEmail = $approverEmail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Approver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
