<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AppointmentAttendee StructType
 * @subpackage Structs
 */
class AppointmentAttendee extends CvObject
{
    /**
     * The EntityType
     * @var string
     */
    public $EntityType;
    /**
     * The AppointmentID
     * @var string
     */
    public $AppointmentID;
    /**
     * The IsOrganizer
     * @var bool
     */
    public $IsOrganizer;
    /**
     * The AppointmentAttendeeStatus
     * @var string
     */
    public $AppointmentAttendeeStatus;
    /**
     * The AppointmentAttendeeNote
     * @var string
     */
    public $AppointmentAttendeeNote;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * Constructor method for AppointmentAttendee
     * @uses AppointmentAttendee::setEntityType()
     * @uses AppointmentAttendee::setAppointmentID()
     * @uses AppointmentAttendee::setIsOrganizer()
     * @uses AppointmentAttendee::setAppointmentAttendeeStatus()
     * @uses AppointmentAttendee::setAppointmentAttendeeNote()
     * @uses AppointmentAttendee::setCreatedDate()
     * @uses AppointmentAttendee::setCreatedBy()
     * @uses AppointmentAttendee::setLastModifiedDate()
     * @uses AppointmentAttendee::setLastModifiedBy()
     * @param string $entityType
     * @param string $appointmentID
     * @param bool $isOrganizer
     * @param string $appointmentAttendeeStatus
     * @param string $appointmentAttendeeNote
     * @param string $createdDate
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     */
    public function __construct($entityType = null, $appointmentID = null, $isOrganizer = null, $appointmentAttendeeStatus = null, $appointmentAttendeeNote = null, $createdDate = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null)
    {
        $this
            ->setEntityType($entityType)
            ->setAppointmentID($appointmentID)
            ->setIsOrganizer($isOrganizer)
            ->setAppointmentAttendeeStatus($appointmentAttendeeStatus)
            ->setAppointmentAttendeeNote($appointmentAttendeeNote)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy);
    }
    /**
     * Get EntityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @param string $entityType
     * @return \StructType\AppointmentAttendee
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get AppointmentID value
     * @return string|null
     */
    public function getAppointmentID()
    {
        return $this->AppointmentID;
    }
    /**
     * Set AppointmentID value
     * @param string $appointmentID
     * @return \StructType\AppointmentAttendee
     */
    public function setAppointmentID($appointmentID = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentID) && !is_string($appointmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentID, true), gettype($appointmentID)), __LINE__);
        }
        $this->AppointmentID = $appointmentID;
        return $this;
    }
    /**
     * Get IsOrganizer value
     * @return bool|null
     */
    public function getIsOrganizer()
    {
        return $this->IsOrganizer;
    }
    /**
     * Set IsOrganizer value
     * @param bool $isOrganizer
     * @return \StructType\AppointmentAttendee
     */
    public function setIsOrganizer($isOrganizer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOrganizer) && !is_bool($isOrganizer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOrganizer, true), gettype($isOrganizer)), __LINE__);
        }
        $this->IsOrganizer = $isOrganizer;
        return $this;
    }
    /**
     * Get AppointmentAttendeeStatus value
     * @return string|null
     */
    public function getAppointmentAttendeeStatus()
    {
        return $this->AppointmentAttendeeStatus;
    }
    /**
     * Set AppointmentAttendeeStatus value
     * @param string $appointmentAttendeeStatus
     * @return \StructType\AppointmentAttendee
     */
    public function setAppointmentAttendeeStatus($appointmentAttendeeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentAttendeeStatus) && !is_string($appointmentAttendeeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentAttendeeStatus, true), gettype($appointmentAttendeeStatus)), __LINE__);
        }
        $this->AppointmentAttendeeStatus = $appointmentAttendeeStatus;
        return $this;
    }
    /**
     * Get AppointmentAttendeeNote value
     * @return string|null
     */
    public function getAppointmentAttendeeNote()
    {
        return $this->AppointmentAttendeeNote;
    }
    /**
     * Set AppointmentAttendeeNote value
     * @param string $appointmentAttendeeNote
     * @return \StructType\AppointmentAttendee
     */
    public function setAppointmentAttendeeNote($appointmentAttendeeNote = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentAttendeeNote) && !is_string($appointmentAttendeeNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentAttendeeNote, true), gettype($appointmentAttendeeNote)), __LINE__);
        }
        $this->AppointmentAttendeeNote = $appointmentAttendeeNote;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\AppointmentAttendee
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\AppointmentAttendee
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\AppointmentAttendee
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\AppointmentAttendee
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AppointmentAttendee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
