<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Appointment StructType
 * @subpackage Structs
 */
class Appointment extends CvObject
{
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The AppointmentTitle
     * @var string
     */
    public $AppointmentTitle;
    /**
     * The AppointmentDescription
     * @var string
     */
    public $AppointmentDescription;
    /**
     * The AppointmentStatus
     * @var string
     */
    public $AppointmentStatus;
    /**
     * The AppointmentType
     * @var string
     */
    public $AppointmentType;
    /**
     * The AppointmentLocation
     * @var string
     */
    public $AppointmentLocation;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * Constructor method for Appointment
     * @uses Appointment::setEventId()
     * @uses Appointment::setAppointmentTitle()
     * @uses Appointment::setAppointmentDescription()
     * @uses Appointment::setAppointmentStatus()
     * @uses Appointment::setAppointmentType()
     * @uses Appointment::setAppointmentLocation()
     * @uses Appointment::setStartDate()
     * @uses Appointment::setEndDate()
     * @uses Appointment::setCreatedDate()
     * @uses Appointment::setCreatedBy()
     * @uses Appointment::setLastModifiedDate()
     * @uses Appointment::setLastModifiedBy()
     * @param string $eventId
     * @param string $appointmentTitle
     * @param string $appointmentDescription
     * @param string $appointmentStatus
     * @param string $appointmentType
     * @param string $appointmentLocation
     * @param string $startDate
     * @param string $endDate
     * @param string $createdDate
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     */
    public function __construct($eventId = null, $appointmentTitle = null, $appointmentDescription = null, $appointmentStatus = null, $appointmentType = null, $appointmentLocation = null, $startDate = null, $endDate = null, $createdDate = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null)
    {
        $this
            ->setEventId($eventId)
            ->setAppointmentTitle($appointmentTitle)
            ->setAppointmentDescription($appointmentDescription)
            ->setAppointmentStatus($appointmentStatus)
            ->setAppointmentType($appointmentType)
            ->setAppointmentLocation($appointmentLocation)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\Appointment
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get AppointmentTitle value
     * @return string|null
     */
    public function getAppointmentTitle()
    {
        return $this->AppointmentTitle;
    }
    /**
     * Set AppointmentTitle value
     * @param string $appointmentTitle
     * @return \StructType\Appointment
     */
    public function setAppointmentTitle($appointmentTitle = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentTitle) && !is_string($appointmentTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentTitle, true), gettype($appointmentTitle)), __LINE__);
        }
        $this->AppointmentTitle = $appointmentTitle;
        return $this;
    }
    /**
     * Get AppointmentDescription value
     * @return string|null
     */
    public function getAppointmentDescription()
    {
        return $this->AppointmentDescription;
    }
    /**
     * Set AppointmentDescription value
     * @param string $appointmentDescription
     * @return \StructType\Appointment
     */
    public function setAppointmentDescription($appointmentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentDescription) && !is_string($appointmentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentDescription, true), gettype($appointmentDescription)), __LINE__);
        }
        $this->AppointmentDescription = $appointmentDescription;
        return $this;
    }
    /**
     * Get AppointmentStatus value
     * @return string|null
     */
    public function getAppointmentStatus()
    {
        return $this->AppointmentStatus;
    }
    /**
     * Set AppointmentStatus value
     * @param string $appointmentStatus
     * @return \StructType\Appointment
     */
    public function setAppointmentStatus($appointmentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentStatus) && !is_string($appointmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentStatus, true), gettype($appointmentStatus)), __LINE__);
        }
        $this->AppointmentStatus = $appointmentStatus;
        return $this;
    }
    /**
     * Get AppointmentType value
     * @return string|null
     */
    public function getAppointmentType()
    {
        return $this->AppointmentType;
    }
    /**
     * Set AppointmentType value
     * @param string $appointmentType
     * @return \StructType\Appointment
     */
    public function setAppointmentType($appointmentType = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentType) && !is_string($appointmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentType, true), gettype($appointmentType)), __LINE__);
        }
        $this->AppointmentType = $appointmentType;
        return $this;
    }
    /**
     * Get AppointmentLocation value
     * @return string|null
     */
    public function getAppointmentLocation()
    {
        return $this->AppointmentLocation;
    }
    /**
     * Set AppointmentLocation value
     * @param string $appointmentLocation
     * @return \StructType\Appointment
     */
    public function setAppointmentLocation($appointmentLocation = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentLocation) && !is_string($appointmentLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentLocation, true), gettype($appointmentLocation)), __LINE__);
        }
        $this->AppointmentLocation = $appointmentLocation;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Appointment
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Appointment
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Appointment
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\Appointment
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Appointment
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\Appointment
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Appointment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
