<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountDetail StructType
 * @subpackage Structs
 */
class AmountDetail extends AbstractStructBase
{
    /**
     * The AmountDetailId
     * @var string
     */
    public $AmountDetailId;
    /**
     * The AmountName
     * @var string
     */
    public $AmountName;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for AmountDetail
     * @uses AmountDetail::setAmountDetailId()
     * @uses AmountDetail::setAmountName()
     * @uses AmountDetail::setAmount()
     * @param string $amountDetailId
     * @param string $amountName
     * @param float $amount
     */
    public function __construct($amountDetailId = null, $amountName = null, $amount = null)
    {
        $this
            ->setAmountDetailId($amountDetailId)
            ->setAmountName($amountName)
            ->setAmount($amount);
    }
    /**
     * Get AmountDetailId value
     * @return string|null
     */
    public function getAmountDetailId()
    {
        return $this->AmountDetailId;
    }
    /**
     * Set AmountDetailId value
     * @param string $amountDetailId
     * @return \StructType\AmountDetail
     */
    public function setAmountDetailId($amountDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($amountDetailId) && !is_string($amountDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountDetailId, true), gettype($amountDetailId)), __LINE__);
        }
        $this->AmountDetailId = $amountDetailId;
        return $this;
    }
    /**
     * Get AmountName value
     * @return string|null
     */
    public function getAmountName()
    {
        return $this->AmountName;
    }
    /**
     * Set AmountName value
     * @param string $amountName
     * @return \StructType\AmountDetail
     */
    public function setAmountName($amountName = null)
    {
        // validation for constraint: string
        if (!is_null($amountName) && !is_string($amountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountName, true), gettype($amountName)), __LINE__);
        }
        $this->AmountName = $amountName;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AmountDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AmountDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
