<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateDates StructType
 * @subpackage Structs
 */
class AlternateDates extends AbstractStructBase
{
    /**
     * The DayNumber
     * @var int
     */
    public $DayNumber;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * The Notes
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for AlternateDates
     * @uses AlternateDates::setDayNumber()
     * @uses AlternateDates::setStartDate()
     * @uses AlternateDates::setEndDate()
     * @uses AlternateDates::setNotes()
     * @param int $dayNumber
     * @param string $startDate
     * @param string $endDate
     * @param string $notes
     */
    public function __construct($dayNumber = null, $startDate = null, $endDate = null, $notes = null)
    {
        $this
            ->setDayNumber($dayNumber)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setNotes($notes);
    }
    /**
     * Get DayNumber value
     * @return int|null
     */
    public function getDayNumber()
    {
        return $this->DayNumber;
    }
    /**
     * Set DayNumber value
     * @param int $dayNumber
     * @return \StructType\AlternateDates
     */
    public function setDayNumber($dayNumber = null)
    {
        // validation for constraint: int
        if (!is_null($dayNumber) && !(is_int($dayNumber) || ctype_digit($dayNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayNumber, true), gettype($dayNumber)), __LINE__);
        }
        $this->DayNumber = $dayNumber;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\AlternateDates
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\AlternateDates
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\AlternateDates
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlternateDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
