<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllocationCategoryDetail StructType
 * @subpackage Structs
 */
class AllocationCategoryDetail extends AbstractStructBase
{
    /**
     * The AllocationCategoryID
     * @var string
     */
    public $AllocationCategoryID;
    /**
     * The AllocationCategoryName
     * @var string
     */
    public $AllocationCategoryName;
    /**
     * The AllocationSubCategoryID
     * @var string
     */
    public $AllocationSubCategoryID;
    /**
     * The AllocationSubCategoryName
     * @var string
     */
    public $AllocationSubCategoryName;
    /**
     * The AllocationPercentage
     * @var float
     */
    public $AllocationPercentage;
    /**
     * Constructor method for AllocationCategoryDetail
     * @uses AllocationCategoryDetail::setAllocationCategoryID()
     * @uses AllocationCategoryDetail::setAllocationCategoryName()
     * @uses AllocationCategoryDetail::setAllocationSubCategoryID()
     * @uses AllocationCategoryDetail::setAllocationSubCategoryName()
     * @uses AllocationCategoryDetail::setAllocationPercentage()
     * @param string $allocationCategoryID
     * @param string $allocationCategoryName
     * @param string $allocationSubCategoryID
     * @param string $allocationSubCategoryName
     * @param float $allocationPercentage
     */
    public function __construct($allocationCategoryID = null, $allocationCategoryName = null, $allocationSubCategoryID = null, $allocationSubCategoryName = null, $allocationPercentage = null)
    {
        $this
            ->setAllocationCategoryID($allocationCategoryID)
            ->setAllocationCategoryName($allocationCategoryName)
            ->setAllocationSubCategoryID($allocationSubCategoryID)
            ->setAllocationSubCategoryName($allocationSubCategoryName)
            ->setAllocationPercentage($allocationPercentage);
    }
    /**
     * Get AllocationCategoryID value
     * @return string|null
     */
    public function getAllocationCategoryID()
    {
        return $this->AllocationCategoryID;
    }
    /**
     * Set AllocationCategoryID value
     * @param string $allocationCategoryID
     * @return \StructType\AllocationCategoryDetail
     */
    public function setAllocationCategoryID($allocationCategoryID = null)
    {
        // validation for constraint: string
        if (!is_null($allocationCategoryID) && !is_string($allocationCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationCategoryID, true), gettype($allocationCategoryID)), __LINE__);
        }
        $this->AllocationCategoryID = $allocationCategoryID;
        return $this;
    }
    /**
     * Get AllocationCategoryName value
     * @return string|null
     */
    public function getAllocationCategoryName()
    {
        return $this->AllocationCategoryName;
    }
    /**
     * Set AllocationCategoryName value
     * @param string $allocationCategoryName
     * @return \StructType\AllocationCategoryDetail
     */
    public function setAllocationCategoryName($allocationCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($allocationCategoryName) && !is_string($allocationCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationCategoryName, true), gettype($allocationCategoryName)), __LINE__);
        }
        $this->AllocationCategoryName = $allocationCategoryName;
        return $this;
    }
    /**
     * Get AllocationSubCategoryID value
     * @return string|null
     */
    public function getAllocationSubCategoryID()
    {
        return $this->AllocationSubCategoryID;
    }
    /**
     * Set AllocationSubCategoryID value
     * @param string $allocationSubCategoryID
     * @return \StructType\AllocationCategoryDetail
     */
    public function setAllocationSubCategoryID($allocationSubCategoryID = null)
    {
        // validation for constraint: string
        if (!is_null($allocationSubCategoryID) && !is_string($allocationSubCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationSubCategoryID, true), gettype($allocationSubCategoryID)), __LINE__);
        }
        $this->AllocationSubCategoryID = $allocationSubCategoryID;
        return $this;
    }
    /**
     * Get AllocationSubCategoryName value
     * @return string|null
     */
    public function getAllocationSubCategoryName()
    {
        return $this->AllocationSubCategoryName;
    }
    /**
     * Set AllocationSubCategoryName value
     * @param string $allocationSubCategoryName
     * @return \StructType\AllocationCategoryDetail
     */
    public function setAllocationSubCategoryName($allocationSubCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($allocationSubCategoryName) && !is_string($allocationSubCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationSubCategoryName, true), gettype($allocationSubCategoryName)), __LINE__);
        }
        $this->AllocationSubCategoryName = $allocationSubCategoryName;
        return $this;
    }
    /**
     * Get AllocationPercentage value
     * @return float|null
     */
    public function getAllocationPercentage()
    {
        return $this->AllocationPercentage;
    }
    /**
     * Set AllocationPercentage value
     * @param float $allocationPercentage
     * @return \StructType\AllocationCategoryDetail
     */
    public function setAllocationPercentage($allocationPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($allocationPercentage) && !(is_float($allocationPercentage) || is_numeric($allocationPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allocationPercentage, true), gettype($allocationPercentage)), __LINE__);
        }
        $this->AllocationPercentage = $allocationPercentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllocationCategoryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
