<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirRequest StructType
 * @subpackage Structs
 */
class AirRequest extends AbstractStructBase
{
    /**
     * The TravelSurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelSurveyDetail[]
     */
    public $TravelSurveyDetail;
    /**
     * The RequesterId
     * @var string
     */
    public $RequesterId;
    /**
     * The RequesterType
     * @var string
     */
    public $RequesterType;
    /**
     * The RequesterFirstName
     * @var string
     */
    public $RequesterFirstName;
    /**
     * The RequesterMiddleName
     * @var string
     */
    public $RequesterMiddleName;
    /**
     * The RequesterLastName
     * @var string
     */
    public $RequesterLastName;
    /**
     * The RequesterSuffix
     * @var string
     */
    public $RequesterSuffix;
    /**
     * The RedressNumber
     * @var string
     */
    public $RedressNumber;
    /**
     * The KnownTravelerNumber
     * @var string
     */
    public $KnownTravelerNumber;
    /**
     * The Leg1Origin
     * @var string
     */
    public $Leg1Origin;
    /**
     * The Leg1Destination
     * @var string
     */
    public $Leg1Destination;
    /**
     * The Leg1Date
     * @var string
     */
    public $Leg1Date;
    /**
     * The Leg1Time
     * @var string
     */
    public $Leg1Time;
    /**
     * The Leg2Origin
     * @var string
     */
    public $Leg2Origin;
    /**
     * The Leg2Destination
     * @var string
     */
    public $Leg2Destination;
    /**
     * The Leg2Date
     * @var string
     */
    public $Leg2Date;
    /**
     * The Leg2Time
     * @var string
     */
    public $Leg2Time;
    /**
     * The TicketType
     * @var string
     */
    public $TicketType;
    /**
     * The SeatType
     * @var string
     */
    public $SeatType;
    /**
     * The MealText
     * @var string
     */
    public $MealText;
    /**
     * The OtherText
     * @var string
     */
    public $OtherText;
    /**
     * The RewardsCode1
     * @var string
     */
    public $RewardsCode1;
    /**
     * The RewardsCode2
     * @var string
     */
    public $RewardsCode2;
    /**
     * The RewardsCode3
     * @var string
     */
    public $RewardsCode3;
    /**
     * The AirlinePreference1
     * @var string
     */
    public $AirlinePreference1;
    /**
     * The AirlinePreference2
     * @var string
     */
    public $AirlinePreference2;
    /**
     * The AirlinePreference3
     * @var string
     */
    public $AirlinePreference3;
    /**
     * The AgeCategory
     * @var string
     */
    public $AgeCategory;
    /**
     * The Cancelled
     * @var bool
     */
    public $Cancelled;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The PlannerMemo
     * @var string
     */
    public $PlannerMemo;
    /**
     * The FullName
     * @var string
     */
    public $FullName;
    /**
     * The DateOfBirth
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The AirLastModifiedDate
     * @var string
     */
    public $AirLastModifiedDate;
    /**
     * Constructor method for AirRequest
     * @uses AirRequest::setTravelSurveyDetail()
     * @uses AirRequest::setRequesterId()
     * @uses AirRequest::setRequesterType()
     * @uses AirRequest::setRequesterFirstName()
     * @uses AirRequest::setRequesterMiddleName()
     * @uses AirRequest::setRequesterLastName()
     * @uses AirRequest::setRequesterSuffix()
     * @uses AirRequest::setRedressNumber()
     * @uses AirRequest::setKnownTravelerNumber()
     * @uses AirRequest::setLeg1Origin()
     * @uses AirRequest::setLeg1Destination()
     * @uses AirRequest::setLeg1Date()
     * @uses AirRequest::setLeg1Time()
     * @uses AirRequest::setLeg2Origin()
     * @uses AirRequest::setLeg2Destination()
     * @uses AirRequest::setLeg2Date()
     * @uses AirRequest::setLeg2Time()
     * @uses AirRequest::setTicketType()
     * @uses AirRequest::setSeatType()
     * @uses AirRequest::setMealText()
     * @uses AirRequest::setOtherText()
     * @uses AirRequest::setRewardsCode1()
     * @uses AirRequest::setRewardsCode2()
     * @uses AirRequest::setRewardsCode3()
     * @uses AirRequest::setAirlinePreference1()
     * @uses AirRequest::setAirlinePreference2()
     * @uses AirRequest::setAirlinePreference3()
     * @uses AirRequest::setAgeCategory()
     * @uses AirRequest::setCancelled()
     * @uses AirRequest::setStatus()
     * @uses AirRequest::setPlannerMemo()
     * @uses AirRequest::setFullName()
     * @uses AirRequest::setDateOfBirth()
     * @uses AirRequest::setGender()
     * @uses AirRequest::setLastModifiedBy()
     * @uses AirRequest::setAirLastModifiedDate()
     * @param \StructType\TravelSurveyDetail[] $travelSurveyDetail
     * @param string $requesterId
     * @param string $requesterType
     * @param string $requesterFirstName
     * @param string $requesterMiddleName
     * @param string $requesterLastName
     * @param string $requesterSuffix
     * @param string $redressNumber
     * @param string $knownTravelerNumber
     * @param string $leg1Origin
     * @param string $leg1Destination
     * @param string $leg1Date
     * @param string $leg1Time
     * @param string $leg2Origin
     * @param string $leg2Destination
     * @param string $leg2Date
     * @param string $leg2Time
     * @param string $ticketType
     * @param string $seatType
     * @param string $mealText
     * @param string $otherText
     * @param string $rewardsCode1
     * @param string $rewardsCode2
     * @param string $rewardsCode3
     * @param string $airlinePreference1
     * @param string $airlinePreference2
     * @param string $airlinePreference3
     * @param string $ageCategory
     * @param bool $cancelled
     * @param string $status
     * @param string $plannerMemo
     * @param string $fullName
     * @param string $dateOfBirth
     * @param string $gender
     * @param string $lastModifiedBy
     * @param string $airLastModifiedDate
     */
    public function __construct(array $travelSurveyDetail = array(), $requesterId = null, $requesterType = null, $requesterFirstName = null, $requesterMiddleName = null, $requesterLastName = null, $requesterSuffix = null, $redressNumber = null, $knownTravelerNumber = null, $leg1Origin = null, $leg1Destination = null, $leg1Date = null, $leg1Time = null, $leg2Origin = null, $leg2Destination = null, $leg2Date = null, $leg2Time = null, $ticketType = null, $seatType = null, $mealText = null, $otherText = null, $rewardsCode1 = null, $rewardsCode2 = null, $rewardsCode3 = null, $airlinePreference1 = null, $airlinePreference2 = null, $airlinePreference3 = null, $ageCategory = null, $cancelled = null, $status = null, $plannerMemo = null, $fullName = null, $dateOfBirth = null, $gender = null, $lastModifiedBy = null, $airLastModifiedDate = null)
    {
        $this
            ->setTravelSurveyDetail($travelSurveyDetail)
            ->setRequesterId($requesterId)
            ->setRequesterType($requesterType)
            ->setRequesterFirstName($requesterFirstName)
            ->setRequesterMiddleName($requesterMiddleName)
            ->setRequesterLastName($requesterLastName)
            ->setRequesterSuffix($requesterSuffix)
            ->setRedressNumber($redressNumber)
            ->setKnownTravelerNumber($knownTravelerNumber)
            ->setLeg1Origin($leg1Origin)
            ->setLeg1Destination($leg1Destination)
            ->setLeg1Date($leg1Date)
            ->setLeg1Time($leg1Time)
            ->setLeg2Origin($leg2Origin)
            ->setLeg2Destination($leg2Destination)
            ->setLeg2Date($leg2Date)
            ->setLeg2Time($leg2Time)
            ->setTicketType($ticketType)
            ->setSeatType($seatType)
            ->setMealText($mealText)
            ->setOtherText($otherText)
            ->setRewardsCode1($rewardsCode1)
            ->setRewardsCode2($rewardsCode2)
            ->setRewardsCode3($rewardsCode3)
            ->setAirlinePreference1($airlinePreference1)
            ->setAirlinePreference2($airlinePreference2)
            ->setAirlinePreference3($airlinePreference3)
            ->setAgeCategory($ageCategory)
            ->setCancelled($cancelled)
            ->setStatus($status)
            ->setPlannerMemo($plannerMemo)
            ->setFullName($fullName)
            ->setDateOfBirth($dateOfBirth)
            ->setGender($gender)
            ->setLastModifiedBy($lastModifiedBy)
            ->setAirLastModifiedDate($airLastModifiedDate);
    }
    /**
     * Get TravelSurveyDetail value
     * @return \StructType\TravelSurveyDetail[]|null
     */
    public function getTravelSurveyDetail()
    {
        return $this->TravelSurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelSurveyDetailForArrayConstraintsFromSetTravelSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airRequestTravelSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$airRequestTravelSurveyDetailItem instanceof \StructType\TravelSurveyDetail) {
                $invalidValues[] = is_object($airRequestTravelSurveyDetailItem) ? get_class($airRequestTravelSurveyDetailItem) : sprintf('%s(%s)', gettype($airRequestTravelSurveyDetailItem), var_export($airRequestTravelSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelSurveyDetail property can only contain items of type \StructType\TravelSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelSurveyDetail[] $travelSurveyDetail
     * @return \StructType\AirRequest
     */
    public function setTravelSurveyDetail(array $travelSurveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($travelSurveyDetailArrayErrorMessage = self::validateTravelSurveyDetailForArrayConstraintsFromSetTravelSurveyDetail($travelSurveyDetail))) {
            throw new \InvalidArgumentException($travelSurveyDetailArrayErrorMessage, __LINE__);
        }
        $this->TravelSurveyDetail = $travelSurveyDetail;
        return $this;
    }
    /**
     * Add item to TravelSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelSurveyDetail $item
     * @return \StructType\AirRequest
     */
    public function addToTravelSurveyDetail(\StructType\TravelSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The TravelSurveyDetail property can only contain items of type \StructType\TravelSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelSurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get RequesterId value
     * @return string|null
     */
    public function getRequesterId()
    {
        return $this->RequesterId;
    }
    /**
     * Set RequesterId value
     * @param string $requesterId
     * @return \StructType\AirRequest
     */
    public function setRequesterId($requesterId = null)
    {
        // validation for constraint: string
        if (!is_null($requesterId) && !is_string($requesterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterId, true), gettype($requesterId)), __LINE__);
        }
        $this->RequesterId = $requesterId;
        return $this;
    }
    /**
     * Get RequesterType value
     * @return string|null
     */
    public function getRequesterType()
    {
        return $this->RequesterType;
    }
    /**
     * Set RequesterType value
     * @param string $requesterType
     * @return \StructType\AirRequest
     */
    public function setRequesterType($requesterType = null)
    {
        // validation for constraint: string
        if (!is_null($requesterType) && !is_string($requesterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterType, true), gettype($requesterType)), __LINE__);
        }
        $this->RequesterType = $requesterType;
        return $this;
    }
    /**
     * Get RequesterFirstName value
     * @return string|null
     */
    public function getRequesterFirstName()
    {
        return $this->RequesterFirstName;
    }
    /**
     * Set RequesterFirstName value
     * @param string $requesterFirstName
     * @return \StructType\AirRequest
     */
    public function setRequesterFirstName($requesterFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterFirstName) && !is_string($requesterFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterFirstName, true), gettype($requesterFirstName)), __LINE__);
        }
        $this->RequesterFirstName = $requesterFirstName;
        return $this;
    }
    /**
     * Get RequesterMiddleName value
     * @return string|null
     */
    public function getRequesterMiddleName()
    {
        return $this->RequesterMiddleName;
    }
    /**
     * Set RequesterMiddleName value
     * @param string $requesterMiddleName
     * @return \StructType\AirRequest
     */
    public function setRequesterMiddleName($requesterMiddleName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterMiddleName) && !is_string($requesterMiddleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterMiddleName, true), gettype($requesterMiddleName)), __LINE__);
        }
        $this->RequesterMiddleName = $requesterMiddleName;
        return $this;
    }
    /**
     * Get RequesterLastName value
     * @return string|null
     */
    public function getRequesterLastName()
    {
        return $this->RequesterLastName;
    }
    /**
     * Set RequesterLastName value
     * @param string $requesterLastName
     * @return \StructType\AirRequest
     */
    public function setRequesterLastName($requesterLastName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterLastName) && !is_string($requesterLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterLastName, true), gettype($requesterLastName)), __LINE__);
        }
        $this->RequesterLastName = $requesterLastName;
        return $this;
    }
    /**
     * Get RequesterSuffix value
     * @return string|null
     */
    public function getRequesterSuffix()
    {
        return $this->RequesterSuffix;
    }
    /**
     * Set RequesterSuffix value
     * @param string $requesterSuffix
     * @return \StructType\AirRequest
     */
    public function setRequesterSuffix($requesterSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($requesterSuffix) && !is_string($requesterSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterSuffix, true), gettype($requesterSuffix)), __LINE__);
        }
        $this->RequesterSuffix = $requesterSuffix;
        return $this;
    }
    /**
     * Get RedressNumber value
     * @return string|null
     */
    public function getRedressNumber()
    {
        return $this->RedressNumber;
    }
    /**
     * Set RedressNumber value
     * @param string $redressNumber
     * @return \StructType\AirRequest
     */
    public function setRedressNumber($redressNumber = null)
    {
        // validation for constraint: string
        if (!is_null($redressNumber) && !is_string($redressNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redressNumber, true), gettype($redressNumber)), __LINE__);
        }
        $this->RedressNumber = $redressNumber;
        return $this;
    }
    /**
     * Get KnownTravelerNumber value
     * @return string|null
     */
    public function getKnownTravelerNumber()
    {
        return $this->KnownTravelerNumber;
    }
    /**
     * Set KnownTravelerNumber value
     * @param string $knownTravelerNumber
     * @return \StructType\AirRequest
     */
    public function setKnownTravelerNumber($knownTravelerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($knownTravelerNumber) && !is_string($knownTravelerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knownTravelerNumber, true), gettype($knownTravelerNumber)), __LINE__);
        }
        $this->KnownTravelerNumber = $knownTravelerNumber;
        return $this;
    }
    /**
     * Get Leg1Origin value
     * @return string|null
     */
    public function getLeg1Origin()
    {
        return $this->Leg1Origin;
    }
    /**
     * Set Leg1Origin value
     * @param string $leg1Origin
     * @return \StructType\AirRequest
     */
    public function setLeg1Origin($leg1Origin = null)
    {
        // validation for constraint: string
        if (!is_null($leg1Origin) && !is_string($leg1Origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg1Origin, true), gettype($leg1Origin)), __LINE__);
        }
        $this->Leg1Origin = $leg1Origin;
        return $this;
    }
    /**
     * Get Leg1Destination value
     * @return string|null
     */
    public function getLeg1Destination()
    {
        return $this->Leg1Destination;
    }
    /**
     * Set Leg1Destination value
     * @param string $leg1Destination
     * @return \StructType\AirRequest
     */
    public function setLeg1Destination($leg1Destination = null)
    {
        // validation for constraint: string
        if (!is_null($leg1Destination) && !is_string($leg1Destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg1Destination, true), gettype($leg1Destination)), __LINE__);
        }
        $this->Leg1Destination = $leg1Destination;
        return $this;
    }
    /**
     * Get Leg1Date value
     * @return string|null
     */
    public function getLeg1Date()
    {
        return $this->Leg1Date;
    }
    /**
     * Set Leg1Date value
     * @param string $leg1Date
     * @return \StructType\AirRequest
     */
    public function setLeg1Date($leg1Date = null)
    {
        // validation for constraint: string
        if (!is_null($leg1Date) && !is_string($leg1Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg1Date, true), gettype($leg1Date)), __LINE__);
        }
        $this->Leg1Date = $leg1Date;
        return $this;
    }
    /**
     * Get Leg1Time value
     * @return string|null
     */
    public function getLeg1Time()
    {
        return $this->Leg1Time;
    }
    /**
     * Set Leg1Time value
     * @param string $leg1Time
     * @return \StructType\AirRequest
     */
    public function setLeg1Time($leg1Time = null)
    {
        // validation for constraint: string
        if (!is_null($leg1Time) && !is_string($leg1Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg1Time, true), gettype($leg1Time)), __LINE__);
        }
        $this->Leg1Time = $leg1Time;
        return $this;
    }
    /**
     * Get Leg2Origin value
     * @return string|null
     */
    public function getLeg2Origin()
    {
        return $this->Leg2Origin;
    }
    /**
     * Set Leg2Origin value
     * @param string $leg2Origin
     * @return \StructType\AirRequest
     */
    public function setLeg2Origin($leg2Origin = null)
    {
        // validation for constraint: string
        if (!is_null($leg2Origin) && !is_string($leg2Origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg2Origin, true), gettype($leg2Origin)), __LINE__);
        }
        $this->Leg2Origin = $leg2Origin;
        return $this;
    }
    /**
     * Get Leg2Destination value
     * @return string|null
     */
    public function getLeg2Destination()
    {
        return $this->Leg2Destination;
    }
    /**
     * Set Leg2Destination value
     * @param string $leg2Destination
     * @return \StructType\AirRequest
     */
    public function setLeg2Destination($leg2Destination = null)
    {
        // validation for constraint: string
        if (!is_null($leg2Destination) && !is_string($leg2Destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg2Destination, true), gettype($leg2Destination)), __LINE__);
        }
        $this->Leg2Destination = $leg2Destination;
        return $this;
    }
    /**
     * Get Leg2Date value
     * @return string|null
     */
    public function getLeg2Date()
    {
        return $this->Leg2Date;
    }
    /**
     * Set Leg2Date value
     * @param string $leg2Date
     * @return \StructType\AirRequest
     */
    public function setLeg2Date($leg2Date = null)
    {
        // validation for constraint: string
        if (!is_null($leg2Date) && !is_string($leg2Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg2Date, true), gettype($leg2Date)), __LINE__);
        }
        $this->Leg2Date = $leg2Date;
        return $this;
    }
    /**
     * Get Leg2Time value
     * @return string|null
     */
    public function getLeg2Time()
    {
        return $this->Leg2Time;
    }
    /**
     * Set Leg2Time value
     * @param string $leg2Time
     * @return \StructType\AirRequest
     */
    public function setLeg2Time($leg2Time = null)
    {
        // validation for constraint: string
        if (!is_null($leg2Time) && !is_string($leg2Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leg2Time, true), gettype($leg2Time)), __LINE__);
        }
        $this->Leg2Time = $leg2Time;
        return $this;
    }
    /**
     * Get TicketType value
     * @return string|null
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @param string $ticketType
     * @return \StructType\AirRequest
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketType) && !is_string($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketType, true), gettype($ticketType)), __LINE__);
        }
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get SeatType value
     * @return string|null
     */
    public function getSeatType()
    {
        return $this->SeatType;
    }
    /**
     * Set SeatType value
     * @param string $seatType
     * @return \StructType\AirRequest
     */
    public function setSeatType($seatType = null)
    {
        // validation for constraint: string
        if (!is_null($seatType) && !is_string($seatType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatType, true), gettype($seatType)), __LINE__);
        }
        $this->SeatType = $seatType;
        return $this;
    }
    /**
     * Get MealText value
     * @return string|null
     */
    public function getMealText()
    {
        return $this->MealText;
    }
    /**
     * Set MealText value
     * @param string $mealText
     * @return \StructType\AirRequest
     */
    public function setMealText($mealText = null)
    {
        // validation for constraint: string
        if (!is_null($mealText) && !is_string($mealText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mealText, true), gettype($mealText)), __LINE__);
        }
        $this->MealText = $mealText;
        return $this;
    }
    /**
     * Get OtherText value
     * @return string|null
     */
    public function getOtherText()
    {
        return $this->OtherText;
    }
    /**
     * Set OtherText value
     * @param string $otherText
     * @return \StructType\AirRequest
     */
    public function setOtherText($otherText = null)
    {
        // validation for constraint: string
        if (!is_null($otherText) && !is_string($otherText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherText, true), gettype($otherText)), __LINE__);
        }
        $this->OtherText = $otherText;
        return $this;
    }
    /**
     * Get RewardsCode1 value
     * @return string|null
     */
    public function getRewardsCode1()
    {
        return $this->RewardsCode1;
    }
    /**
     * Set RewardsCode1 value
     * @param string $rewardsCode1
     * @return \StructType\AirRequest
     */
    public function setRewardsCode1($rewardsCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($rewardsCode1) && !is_string($rewardsCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rewardsCode1, true), gettype($rewardsCode1)), __LINE__);
        }
        $this->RewardsCode1 = $rewardsCode1;
        return $this;
    }
    /**
     * Get RewardsCode2 value
     * @return string|null
     */
    public function getRewardsCode2()
    {
        return $this->RewardsCode2;
    }
    /**
     * Set RewardsCode2 value
     * @param string $rewardsCode2
     * @return \StructType\AirRequest
     */
    public function setRewardsCode2($rewardsCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($rewardsCode2) && !is_string($rewardsCode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rewardsCode2, true), gettype($rewardsCode2)), __LINE__);
        }
        $this->RewardsCode2 = $rewardsCode2;
        return $this;
    }
    /**
     * Get RewardsCode3 value
     * @return string|null
     */
    public function getRewardsCode3()
    {
        return $this->RewardsCode3;
    }
    /**
     * Set RewardsCode3 value
     * @param string $rewardsCode3
     * @return \StructType\AirRequest
     */
    public function setRewardsCode3($rewardsCode3 = null)
    {
        // validation for constraint: string
        if (!is_null($rewardsCode3) && !is_string($rewardsCode3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rewardsCode3, true), gettype($rewardsCode3)), __LINE__);
        }
        $this->RewardsCode3 = $rewardsCode3;
        return $this;
    }
    /**
     * Get AirlinePreference1 value
     * @return string|null
     */
    public function getAirlinePreference1()
    {
        return $this->AirlinePreference1;
    }
    /**
     * Set AirlinePreference1 value
     * @param string $airlinePreference1
     * @return \StructType\AirRequest
     */
    public function setAirlinePreference1($airlinePreference1 = null)
    {
        // validation for constraint: string
        if (!is_null($airlinePreference1) && !is_string($airlinePreference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlinePreference1, true), gettype($airlinePreference1)), __LINE__);
        }
        $this->AirlinePreference1 = $airlinePreference1;
        return $this;
    }
    /**
     * Get AirlinePreference2 value
     * @return string|null
     */
    public function getAirlinePreference2()
    {
        return $this->AirlinePreference2;
    }
    /**
     * Set AirlinePreference2 value
     * @param string $airlinePreference2
     * @return \StructType\AirRequest
     */
    public function setAirlinePreference2($airlinePreference2 = null)
    {
        // validation for constraint: string
        if (!is_null($airlinePreference2) && !is_string($airlinePreference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlinePreference2, true), gettype($airlinePreference2)), __LINE__);
        }
        $this->AirlinePreference2 = $airlinePreference2;
        return $this;
    }
    /**
     * Get AirlinePreference3 value
     * @return string|null
     */
    public function getAirlinePreference3()
    {
        return $this->AirlinePreference3;
    }
    /**
     * Set AirlinePreference3 value
     * @param string $airlinePreference3
     * @return \StructType\AirRequest
     */
    public function setAirlinePreference3($airlinePreference3 = null)
    {
        // validation for constraint: string
        if (!is_null($airlinePreference3) && !is_string($airlinePreference3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlinePreference3, true), gettype($airlinePreference3)), __LINE__);
        }
        $this->AirlinePreference3 = $airlinePreference3;
        return $this;
    }
    /**
     * Get AgeCategory value
     * @return string|null
     */
    public function getAgeCategory()
    {
        return $this->AgeCategory;
    }
    /**
     * Set AgeCategory value
     * @param string $ageCategory
     * @return \StructType\AirRequest
     */
    public function setAgeCategory($ageCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ageCategory) && !is_string($ageCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageCategory, true), gettype($ageCategory)), __LINE__);
        }
        $this->AgeCategory = $ageCategory;
        return $this;
    }
    /**
     * Get Cancelled value
     * @return bool|null
     */
    public function getCancelled()
    {
        return $this->Cancelled;
    }
    /**
     * Set Cancelled value
     * @param bool $cancelled
     * @return \StructType\AirRequest
     */
    public function setCancelled($cancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelled) && !is_bool($cancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelled, true), gettype($cancelled)), __LINE__);
        }
        $this->Cancelled = $cancelled;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\AirRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PlannerMemo value
     * @return string|null
     */
    public function getPlannerMemo()
    {
        return $this->PlannerMemo;
    }
    /**
     * Set PlannerMemo value
     * @param string $plannerMemo
     * @return \StructType\AirRequest
     */
    public function setPlannerMemo($plannerMemo = null)
    {
        // validation for constraint: string
        if (!is_null($plannerMemo) && !is_string($plannerMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerMemo, true), gettype($plannerMemo)), __LINE__);
        }
        $this->PlannerMemo = $plannerMemo;
        return $this;
    }
    /**
     * Get FullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->FullName;
    }
    /**
     * Set FullName value
     * @param string $fullName
     * @return \StructType\AirRequest
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->FullName = $fullName;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\AirRequest
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\AirRequest
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\AirRequest
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get AirLastModifiedDate value
     * @return string|null
     */
    public function getAirLastModifiedDate()
    {
        return $this->AirLastModifiedDate;
    }
    /**
     * Set AirLastModifiedDate value
     * @param string $airLastModifiedDate
     * @return \StructType\AirRequest
     */
    public function setAirLastModifiedDate($airLastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($airLastModifiedDate) && !is_string($airLastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airLastModifiedDate, true), gettype($airLastModifiedDate)), __LINE__);
        }
        $this->AirLastModifiedDate = $airLastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
