<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirActual StructType
 * @subpackage Structs
 */
class AirActual extends AbstractStructBase
{
    /**
     * The FlightDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FlightDetail[]
     */
    public $FlightDetail;
    /**
     * The RequesterId
     * @var string
     */
    public $RequesterId;
    /**
     * The RequesterType
     * @var string
     */
    public $RequesterType;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The ConfirmationNumber
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The TotalAmount
     * @var string
     */
    public $TotalAmount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * The GDSRecordLocator
     * @var string
     */
    public $GDSRecordLocator;
    /**
     * The GDSNote
     * @var string
     */
    public $GDSNote;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The AirActualLastModifiedDate
     * @var string
     */
    public $AirActualLastModifiedDate;
    /**
     * Constructor method for AirActual
     * @uses AirActual::setFlightDetail()
     * @uses AirActual::setRequesterId()
     * @uses AirActual::setRequesterType()
     * @uses AirActual::setName()
     * @uses AirActual::setConfirmationNumber()
     * @uses AirActual::setTotalAmount()
     * @uses AirActual::setCurrencyCode()
     * @uses AirActual::setNote()
     * @uses AirActual::setGDSRecordLocator()
     * @uses AirActual::setGDSNote()
     * @uses AirActual::setLastModifiedBy()
     * @uses AirActual::setAirActualLastModifiedDate()
     * @param \StructType\FlightDetail[] $flightDetail
     * @param string $requesterId
     * @param string $requesterType
     * @param string $name
     * @param string $confirmationNumber
     * @param string $totalAmount
     * @param string $currencyCode
     * @param string $note
     * @param string $gDSRecordLocator
     * @param string $gDSNote
     * @param string $lastModifiedBy
     * @param string $airActualLastModifiedDate
     */
    public function __construct(array $flightDetail = array(), $requesterId = null, $requesterType = null, $name = null, $confirmationNumber = null, $totalAmount = null, $currencyCode = null, $note = null, $gDSRecordLocator = null, $gDSNote = null, $lastModifiedBy = null, $airActualLastModifiedDate = null)
    {
        $this
            ->setFlightDetail($flightDetail)
            ->setRequesterId($requesterId)
            ->setRequesterType($requesterType)
            ->setName($name)
            ->setConfirmationNumber($confirmationNumber)
            ->setTotalAmount($totalAmount)
            ->setCurrencyCode($currencyCode)
            ->setNote($note)
            ->setGDSRecordLocator($gDSRecordLocator)
            ->setGDSNote($gDSNote)
            ->setLastModifiedBy($lastModifiedBy)
            ->setAirActualLastModifiedDate($airActualLastModifiedDate);
    }
    /**
     * Get FlightDetail value
     * @return \StructType\FlightDetail[]|null
     */
    public function getFlightDetail()
    {
        return $this->FlightDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightDetailForArrayConstraintsFromSetFlightDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airActualFlightDetailItem) {
            // validation for constraint: itemType
            if (!$airActualFlightDetailItem instanceof \StructType\FlightDetail) {
                $invalidValues[] = is_object($airActualFlightDetailItem) ? get_class($airActualFlightDetailItem) : sprintf('%s(%s)', gettype($airActualFlightDetailItem), var_export($airActualFlightDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightDetail property can only contain items of type \StructType\FlightDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightDetail[] $flightDetail
     * @return \StructType\AirActual
     */
    public function setFlightDetail(array $flightDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($flightDetailArrayErrorMessage = self::validateFlightDetailForArrayConstraintsFromSetFlightDetail($flightDetail))) {
            throw new \InvalidArgumentException($flightDetailArrayErrorMessage, __LINE__);
        }
        $this->FlightDetail = $flightDetail;
        return $this;
    }
    /**
     * Add item to FlightDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightDetail $item
     * @return \StructType\AirActual
     */
    public function addToFlightDetail(\StructType\FlightDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightDetail) {
            throw new \InvalidArgumentException(sprintf('The FlightDetail property can only contain items of type \StructType\FlightDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FlightDetail[] = $item;
        return $this;
    }
    /**
     * Get RequesterId value
     * @return string|null
     */
    public function getRequesterId()
    {
        return $this->RequesterId;
    }
    /**
     * Set RequesterId value
     * @param string $requesterId
     * @return \StructType\AirActual
     */
    public function setRequesterId($requesterId = null)
    {
        // validation for constraint: string
        if (!is_null($requesterId) && !is_string($requesterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterId, true), gettype($requesterId)), __LINE__);
        }
        $this->RequesterId = $requesterId;
        return $this;
    }
    /**
     * Get RequesterType value
     * @return string|null
     */
    public function getRequesterType()
    {
        return $this->RequesterType;
    }
    /**
     * Set RequesterType value
     * @param string $requesterType
     * @return \StructType\AirActual
     */
    public function setRequesterType($requesterType = null)
    {
        // validation for constraint: string
        if (!is_null($requesterType) && !is_string($requesterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterType, true), gettype($requesterType)), __LINE__);
        }
        $this->RequesterType = $requesterType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AirActual
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\AirActual
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \StructType\AirActual
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: string
        if (!is_null($totalAmount) && !is_string($totalAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AirActual
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\AirActual
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get GDSRecordLocator value
     * @return string|null
     */
    public function getGDSRecordLocator()
    {
        return $this->GDSRecordLocator;
    }
    /**
     * Set GDSRecordLocator value
     * @param string $gDSRecordLocator
     * @return \StructType\AirActual
     */
    public function setGDSRecordLocator($gDSRecordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($gDSRecordLocator) && !is_string($gDSRecordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDSRecordLocator, true), gettype($gDSRecordLocator)), __LINE__);
        }
        $this->GDSRecordLocator = $gDSRecordLocator;
        return $this;
    }
    /**
     * Get GDSNote value
     * @return string|null
     */
    public function getGDSNote()
    {
        return $this->GDSNote;
    }
    /**
     * Set GDSNote value
     * @param string $gDSNote
     * @return \StructType\AirActual
     */
    public function setGDSNote($gDSNote = null)
    {
        // validation for constraint: string
        if (!is_null($gDSNote) && !is_string($gDSNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDSNote, true), gettype($gDSNote)), __LINE__);
        }
        $this->GDSNote = $gDSNote;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\AirActual
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get AirActualLastModifiedDate value
     * @return string|null
     */
    public function getAirActualLastModifiedDate()
    {
        return $this->AirActualLastModifiedDate;
    }
    /**
     * Set AirActualLastModifiedDate value
     * @param string $airActualLastModifiedDate
     * @return \StructType\AirActual
     */
    public function setAirActualLastModifiedDate($airActualLastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($airActualLastModifiedDate) && !is_string($airActualLastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airActualLastModifiedDate, true), gettype($airActualLastModifiedDate)), __LINE__);
        }
        $this->AirActualLastModifiedDate = $airActualLastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirActual
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
