<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvancedLogicChoices StructType
 * @subpackage Structs
 */
class AdvancedLogicChoices extends AbstractStructBase
{
    /**
     * The FieldChoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FieldChoice;
    /**
     * The SourceFieldChoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceFieldChoice;
    /**
     * Constructor method for AdvancedLogicChoices
     * @uses AdvancedLogicChoices::setFieldChoice()
     * @uses AdvancedLogicChoices::setSourceFieldChoice()
     * @param string[] $fieldChoice
     * @param string $sourceFieldChoice
     */
    public function __construct(array $fieldChoice = array(), $sourceFieldChoice = null)
    {
        $this
            ->setFieldChoice($fieldChoice)
            ->setSourceFieldChoice($sourceFieldChoice);
    }
    /**
     * Get FieldChoice value
     * @return string[]|null
     */
    public function getFieldChoice()
    {
        return $this->FieldChoice;
    }
    /**
     * This method is responsible for validating the values passed to the setFieldChoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFieldChoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldChoiceForArrayConstraintsFromSetFieldChoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advancedLogicChoicesFieldChoiceItem) {
            // validation for constraint: itemType
            if (!is_string($advancedLogicChoicesFieldChoiceItem)) {
                $invalidValues[] = is_object($advancedLogicChoicesFieldChoiceItem) ? get_class($advancedLogicChoicesFieldChoiceItem) : sprintf('%s(%s)', gettype($advancedLogicChoicesFieldChoiceItem), var_export($advancedLogicChoicesFieldChoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FieldChoice property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FieldChoice value
     * @throws \InvalidArgumentException
     * @param string[] $fieldChoice
     * @return \StructType\AdvancedLogicChoices
     */
    public function setFieldChoice(array $fieldChoice = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldChoiceArrayErrorMessage = self::validateFieldChoiceForArrayConstraintsFromSetFieldChoice($fieldChoice))) {
            throw new \InvalidArgumentException($fieldChoiceArrayErrorMessage, __LINE__);
        }
        $this->FieldChoice = $fieldChoice;
        return $this;
    }
    /**
     * Add item to FieldChoice value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AdvancedLogicChoices
     */
    public function addToFieldChoice($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FieldChoice property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FieldChoice[] = $item;
        return $this;
    }
    /**
     * Get SourceFieldChoice value
     * @return string|null
     */
    public function getSourceFieldChoice()
    {
        return $this->SourceFieldChoice;
    }
    /**
     * Set SourceFieldChoice value
     * @param string $sourceFieldChoice
     * @return \StructType\AdvancedLogicChoices
     */
    public function setSourceFieldChoice($sourceFieldChoice = null)
    {
        // validation for constraint: string
        if (!is_null($sourceFieldChoice) && !is_string($sourceFieldChoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceFieldChoice, true), gettype($sourceFieldChoice)), __LINE__);
        }
        $this->SourceFieldChoice = $sourceFieldChoice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdvancedLogicChoices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
