<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upsert ServiceType
 * @subpackage Services
 */
class Upsert extends AbstractSoapClientBase
{
    /**
     * Sets the CventSessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\CventSessionHeader $cventSessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCventSessionHeader(\StructType\CventSessionHeader $cventSessionHeader, $nameSpace = 'http://api.cvent.com/2006-11', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CventSessionHeader', $cventSessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpsertContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpsertContact $parameters
     * @return \StructType\UpsertContactResponse|bool
     */
    public function UpsertContact(\StructType\UpsertContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpsertContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpsertContactResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
