<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the CventSessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\CventSessionHeader $cventSessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCventSessionHeader(\StructType\CventSessionHeader $cventSessionHeader, $nameSpace = 'http://api.cvent.com/2006-11', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CventSessionHeader', $cventSessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateContact $parameters
     * @return \StructType\UpdateContactResponse|bool
     */
    public function UpdateContact(\StructType\UpdateContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInviteeInternalInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateInviteeInternalInfo $parameters
     * @return \StructType\UpdateInviteeInternalInfoResponse|bool
     */
    public function UpdateInviteeInternalInfo(\StructType\UpdateInviteeInternalInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateInviteeInternalInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateApprover
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateApprover $parameters
     * @return \StructType\UpdateApproverResponse|bool
     */
    public function UpdateApprover(\StructType\UpdateApprover $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateApprover($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUser $parameters
     * @return \StructType\UpdateUserResponse|bool
     */
    public function UpdateUser(\StructType\UpdateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSession
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSession $parameters
     * @return \StructType\UpdateSessionResponse|bool
     */
    public function UpdateSession(\StructType\UpdateSession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEventParameters
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEventParameters $parameters
     * @return \StructType\UpdateEventParametersResponse|bool
     */
    public function UpdateEventParameters(\StructType\UpdateEventParameters $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateEventParameters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMeetingRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMeetingRequest $parameters
     * @return \StructType\UpdateMeetingRequestResponse|bool
     */
    public function UpdateMeetingRequest(\StructType\UpdateMeetingRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateMeetingRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomField
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomField $parameters
     * @return \StructType\UpdateCustomFieldResponse|bool
     */
    public function UpdateCustomField(\StructType\UpdateCustomField $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomField($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRegistrationType
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRegistrationType $parameters
     * @return \StructType\UpdateRegistrationTypeResponse|bool
     */
    public function UpdateRegistrationType(\StructType\UpdateRegistrationType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateRegistrationType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateGuestInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGuestInfo $parameters
     * @return \StructType\UpdateGuestInfoResponse|bool
     */
    public function UpdateGuestInfo(\StructType\UpdateGuestInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateGuestInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateApproverResponse|\StructType\UpdateContactResponse|\StructType\UpdateCustomFieldResponse|\StructType\UpdateEventParametersResponse|\StructType\UpdateGuestInfoResponse|\StructType\UpdateInviteeInternalInfoResponse|\StructType\UpdateMeetingRequestResponse|\StructType\UpdateRegistrationTypeResponse|\StructType\UpdateSessionResponse|\StructType\UpdateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
