<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Session ServiceType
 * @subpackage Services
 */
class Session extends AbstractSoapClientBase
{
    /**
     * Sets the CventSessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\CventSessionHeader $cventSessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCventSessionHeader(\StructType\CventSessionHeader $cventSessionHeader, $nameSpace = 'http://api.cvent.com/2006-11', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CventSessionHeader', $cventSessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SessionRegAction
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SessionRegAction $parameters
     * @return \StructType\SessionRegActionResponse|bool
     */
    public function SessionRegAction(\StructType\SessionRegAction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SessionRegAction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SessionRegActionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
