<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Manage ServiceType
 * @subpackage Services
 */
class Manage extends AbstractSoapClientBase
{
    /**
     * Sets the CventSessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\CventSessionHeader $cventSessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCventSessionHeader(\StructType\CventSessionHeader $cventSessionHeader, $nameSpace = 'http://api.cvent.com/2006-11', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CventSessionHeader', $cventSessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ManageContactGroupMembers
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManageContactGroupMembers $parameters
     * @return \StructType\ManageContactGroupMembersResponse|bool
     */
    public function ManageContactGroupMembers(\StructType\ManageContactGroupMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ManageContactGroupMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ManageDistributionListMembers
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManageDistributionListMembers $parameters
     * @return \StructType\ManageDistributionListMembersResponse|bool
     */
    public function ManageDistributionListMembers(\StructType\ManageDistributionListMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ManageDistributionListMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ManageUserGroup
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManageUserGroup $parameters
     * @return \StructType\ManageUserGroupResponse|bool
     */
    public function ManageUserGroup(\StructType\ManageUserGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ManageUserGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ManageContactGroupMembersResponse|\StructType\ManageDistributionListMembersResponse|\StructType\ManageUserGroupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
