<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the CventSessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\CventSessionHeader $cventSessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCventSessionHeader(\StructType\CventSessionHeader $cventSessionHeader, $nameSpace = 'http://api.cvent.com/2006-11', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'CventSessionHeader', $cventSessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateContact $parameters
     * @return \StructType\CreateContactResponse|bool
     */
    public function CreateContact(\StructType\CreateContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateContactGroup
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateContactGroup $parameters
     * @return \StructType\CreateContactGroupResponse|bool
     */
    public function CreateContactGroup(\StructType\CreateContactGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateContactGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateDistributionList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateDistributionList $parameters
     * @return \StructType\CreateDistributionListResponse|bool
     */
    public function CreateDistributionList(\StructType\CreateDistributionList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateDistributionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateApprover
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateApprover $parameters
     * @return \StructType\CreateApproverResponse|bool
     */
    public function CreateApprover(\StructType\CreateApprover $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateApprover($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateBudgetItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateBudgetItem $parameters
     * @return \StructType\CreateBudgetItemResponse|bool
     */
    public function CreateBudgetItem(\StructType\CreateBudgetItem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateBudgetItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateUser $parameters
     * @return \StructType\CreateUserResponse|bool
     */
    public function CreateUser(\StructType\CreateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSurveyAnswer
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSurveyAnswer $parameters
     * @return \StructType\CreateSurveyAnswerResponse|bool
     */
    public function CreateSurveyAnswer(\StructType\CreateSurveyAnswer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateSurveyAnswer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePostEventFeedback
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePostEventFeedback $parameters
     * @return \StructType\CreatePostEventFeedbackResponse|bool
     */
    public function CreatePostEventFeedback(\StructType\CreatePostEventFeedback $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePostEventFeedback($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNoRegEvent
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateNoRegEvent $parameters
     * @return \StructType\CreateNoRegEventResponse|bool
     */
    public function CreateNoRegEvent(\StructType\CreateNoRegEvent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateNoRegEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateRateHistory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateRateHistory $parameters
     * @return \StructType\CreateRateHistoryResponse|bool
     */
    public function CreateRateHistory(\StructType\CreateRateHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateRateHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTransaction
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTransaction $parameters
     * @return \StructType\CreateTransactionResponse|bool
     */
    public function CreateTransaction(\StructType\CreateTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateRFP
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateRFP $parameters
     * @return \StructType\CreateRFPResponse|bool
     */
    public function CreateRFP(\StructType\CreateRFP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateRFP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateConversionRate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateConversionRate $parameters
     * @return \StructType\CreateConversionRateResponse|bool
     */
    public function CreateConversionRate(\StructType\CreateConversionRate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateConversionRate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSession
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSession $parameters
     * @return \StructType\CreateSessionResponse|bool
     */
    public function CreateSession(\StructType\CreateSession $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateMeetingRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateMeetingRequest $parameters
     * @return \StructType\CreateMeetingRequestResponse|bool
     */
    public function CreateMeetingRequest(\StructType\CreateMeetingRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateMeetingRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomField
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: CventSessionHeader
     * - SOAPHeaderNamespaces: http://api.cvent.com/2006-11
     * - SOAPHeaderTypes: \StructType\CventSessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomField $parameters
     * @return \StructType\CreateCustomFieldResponse|bool
     */
    public function CreateCustomField(\StructType\CreateCustomField $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCustomField($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateApproverResponse|\StructType\CreateBudgetItemResponse|\StructType\CreateContactGroupResponse|\StructType\CreateContactResponse|\StructType\CreateConversionRateResponse|\StructType\CreateCustomFieldResponse|\StructType\CreateDistributionListResponse|\StructType\CreateMeetingRequestResponse|\StructType\CreateNoRegEventResponse|\StructType\CreatePostEventFeedbackResponse|\StructType\CreateRateHistoryResponse|\StructType\CreateRFPResponse|\StructType\CreateSessionResponse|\StructType\CreateSurveyAnswerResponse|\StructType\CreateTransactionResponse|\StructType\CreateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
