<?php

namespace EnumType;

/**
 * This class stands for TransactionType EnumType
 * @subpackage Enumerations
 */
class TransactionType
{
    /**
     * Constant for value 'Online Charge'
     * @return string 'Online Charge'
     */
    const VALUE_ONLINE_CHARGE = 'Online Charge';
    /**
     * Constant for value 'Online Refund'
     * @return string 'Online Refund'
     */
    const VALUE_ONLINE_REFUND = 'Online Refund';
    /**
     * Constant for value 'Offline Charge'
     * @return string 'Offline Charge'
     */
    const VALUE_OFFLINE_CHARGE = 'Offline Charge';
    /**
     * Constant for value 'Offline Refund'
     * @return string 'Offline Refund'
     */
    const VALUE_OFFLINE_REFUND = 'Offline Refund';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONLINE_CHARGE
     * @uses self::VALUE_ONLINE_REFUND
     * @uses self::VALUE_OFFLINE_CHARGE
     * @uses self::VALUE_OFFLINE_REFUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLINE_CHARGE,
            self::VALUE_ONLINE_REFUND,
            self::VALUE_OFFLINE_CHARGE,
            self::VALUE_OFFLINE_REFUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
