<?php

namespace EnumType;

/**
 * This class stands for SessionRegActionType EnumType
 * @subpackage Enumerations
 */
class SessionRegActionType
{
    /**
     * Constant for value 'Register'
     * @return string 'Register'
     */
    const VALUE_REGISTER = 'Register';
    /**
     * Constant for value 'Unregister'
     * @return string 'Unregister'
     */
    const VALUE_UNREGISTER = 'Unregister';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGISTER
     * @uses self::VALUE_UNREGISTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGISTER,
            self::VALUE_UNREGISTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
