<?php

namespace EnumType;

/**
 * This class stands for RespondentStatus EnumType
 * @subpackage Enumerations
 */
class RespondentStatus
{
    /**
     * Constant for value 'No Response'
     * @return string 'No Response'
     */
    const VALUE_NO_RESPONSE = 'No Response';
    /**
     * Constant for value 'Visited'
     * @return string 'Visited'
     */
    const VALUE_VISITED = 'Visited';
    /**
     * Constant for value 'Partial Response'
     * @return string 'Partial Response'
     */
    const VALUE_PARTIAL_RESPONSE = 'Partial Response';
    /**
     * Constant for value 'Complete Response'
     * @return string 'Complete Response'
     */
    const VALUE_COMPLETE_RESPONSE = 'Complete Response';
    /**
     * Constant for value 'Disqualified Response'
     * @return string 'Disqualified Response'
     */
    const VALUE_DISQUALIFIED_RESPONSE = 'Disqualified Response';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_RESPONSE
     * @uses self::VALUE_VISITED
     * @uses self::VALUE_PARTIAL_RESPONSE
     * @uses self::VALUE_COMPLETE_RESPONSE
     * @uses self::VALUE_DISQUALIFIED_RESPONSE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_RESPONSE,
            self::VALUE_VISITED,
            self::VALUE_PARTIAL_RESPONSE,
            self::VALUE_COMPLETE_RESPONSE,
            self::VALUE_DISQUALIFIED_RESPONSE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
