<?php

namespace EnumType;

/**
 * This class stands for RegistrationAction EnumType
 * @subpackage Enumerations
 */
class RegistrationAction
{
    /**
     * Constant for value 'Register'
     * @return string 'Register'
     */
    const VALUE_REGISTER = 'Register';
    /**
     * Constant for value 'Decline'
     * @return string 'Decline'
     */
    const VALUE_DECLINE = 'Decline';
    /**
     * Constant for value 'Waitlist'
     * @return string 'Waitlist'
     */
    const VALUE_WAITLIST = 'Waitlist';
    /**
     * Constant for value 'Cancel'
     * @return string 'Cancel'
     */
    const VALUE_CANCEL = 'Cancel';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGISTER
     * @uses self::VALUE_DECLINE
     * @uses self::VALUE_WAITLIST
     * @uses self::VALUE_CANCEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGISTER,
            self::VALUE_DECLINE,
            self::VALUE_WAITLIST,
            self::VALUE_CANCEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
