<?php

namespace EnumType;

/**
 * This class stands for ProductType EnumType
 * @subpackage Enumerations
 */
class ProductType
{
    /**
     * Constant for value 'Event'
     * @return string 'Event'
     */
    const VALUE_EVENT = 'Event';
    /**
     * Constant for value 'Session'
     * @return string 'Session'
     */
    const VALUE_SESSION = 'Session';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EVENT
     * @uses self::VALUE_SESSION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EVENT,
            self::VALUE_SESSION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
