<?php

namespace EnumType;

/**
 * This class stands for ProductStatus EnumType
 * @subpackage Enumerations
 */
class ProductStatus
{
    /**
     * Constant for value 'OpenForRegistration'
     * @return string 'OpenForRegistration'
     */
    const VALUE_OPEN_FOR_REGISTRATION = 'OpenForRegistration';
    /**
     * Constant for value 'ClosedForRegistration'
     * @return string 'ClosedForRegistration'
     */
    const VALUE_CLOSED_FOR_REGISTRATION = 'ClosedForRegistration';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPEN_FOR_REGISTRATION
     * @uses self::VALUE_CLOSED_FOR_REGISTRATION
     * @uses self::VALUE_CANCELLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPEN_FOR_REGISTRATION,
            self::VALUE_CLOSED_FOR_REGISTRATION,
            self::VALUE_CANCELLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
