<?php

namespace EnumType;

/**
 * This class stands for PrimaryAddressType EnumType
 * @subpackage Enumerations
 */
class PrimaryAddressType
{
    /**
     * Constant for value 'Work'
     * @return string 'Work'
     */
    const VALUE_WORK = 'Work';
    /**
     * Constant for value 'Home'
     * @return string 'Home'
     */
    const VALUE_HOME = 'Home';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WORK
     * @uses self::VALUE_HOME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WORK,
            self::VALUE_HOME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
