<?php

namespace EnumType;

/**
 * This class stands for ManageDistributionListAction EnumType
 * @subpackage Enumerations
 */
class ManageDistributionListAction
{
    /**
     * Constant for value 'Add'
     * @return string 'Add'
     */
    const VALUE_ADD = 'Add';
    /**
     * Constant for value 'Add as Pending'
     * @return string 'Add as Pending'
     */
    const VALUE_ADD_AS_PENDING = 'Add as Pending';
    /**
     * Constant for value 'Remove'
     * @return string 'Remove'
     */
    const VALUE_REMOVE = 'Remove';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD
     * @uses self::VALUE_ADD_AS_PENDING
     * @uses self::VALUE_REMOVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD,
            self::VALUE_ADD_AS_PENDING,
            self::VALUE_REMOVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
