<?php

namespace EnumType;

/**
 * This class stands for InviteeStatus EnumType
 * @subpackage Enumerations
 */
class InviteeStatus
{
    /**
     * Constant for value 'No Response'
     * @return string 'No Response'
     */
    const VALUE_NO_RESPONSE = 'No Response';
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Declined'
     * @return string 'Declined'
     */
    const VALUE_DECLINED = 'Declined';
    /**
     * Constant for value 'Visited'
     * @return string 'Visited'
     */
    const VALUE_VISITED = 'Visited';
    /**
     * Constant for value 'Waitlisted'
     * @return string 'Waitlisted'
     */
    const VALUE_WAITLISTED = 'Waitlisted';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'Pending Approval'
     * @return string 'Pending Approval'
     */
    const VALUE_PENDING_APPROVAL = 'Pending Approval';
    /**
     * Constant for value 'Denied Approval'
     * @return string 'Denied Approval'
     */
    const VALUE_DENIED_APPROVAL = 'Denied Approval';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_RESPONSE
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_DECLINED
     * @uses self::VALUE_VISITED
     * @uses self::VALUE_WAITLISTED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_PENDING_APPROVAL
     * @uses self::VALUE_DENIED_APPROVAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_RESPONSE,
            self::VALUE_ACCEPTED,
            self::VALUE_DECLINED,
            self::VALUE_VISITED,
            self::VALUE_WAITLISTED,
            self::VALUE_CANCELLED,
            self::VALUE_PENDING_APPROVAL,
            self::VALUE_DENIED_APPROVAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
