<?php

namespace EnumType;

/**
 * This class stands for EventLanguage EnumType
 * @subpackage Enumerations
 */
class EventLanguage
{
    /**
     * Constant for value 'English'
     * @return string 'English'
     */
    const VALUE_ENGLISH = 'English';
    /**
     * Constant for value 'French'
     * @return string 'French'
     */
    const VALUE_FRENCH = 'French';
    /**
     * Constant for value 'German'
     * @return string 'German'
     */
    const VALUE_GERMAN = 'German';
    /**
     * Constant for value 'Italian'
     * @return string 'Italian'
     */
    const VALUE_ITALIAN = 'Italian';
    /**
     * Constant for value 'Japanese'
     * @return string 'Japanese'
     */
    const VALUE_JAPANESE = 'Japanese';
    /**
     * Constant for value 'Portuguese'
     * @return string 'Portuguese'
     */
    const VALUE_PORTUGUESE = 'Portuguese';
    /**
     * Constant for value 'Spanish'
     * @return string 'Spanish'
     */
    const VALUE_SPANISH = 'Spanish';
    /**
     * Constant for value 'Chinese'
     * @return string 'Chinese'
     */
    const VALUE_CHINESE = 'Chinese';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENGLISH
     * @uses self::VALUE_FRENCH
     * @uses self::VALUE_GERMAN
     * @uses self::VALUE_ITALIAN
     * @uses self::VALUE_JAPANESE
     * @uses self::VALUE_PORTUGUESE
     * @uses self::VALUE_SPANISH
     * @uses self::VALUE_CHINESE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENGLISH,
            self::VALUE_FRENCH,
            self::VALUE_GERMAN,
            self::VALUE_ITALIAN,
            self::VALUE_JAPANESE,
            self::VALUE_PORTUGUESE,
            self::VALUE_SPANISH,
            self::VALUE_CHINESE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
