<?php

namespace EnumType;

/**
 * This class stands for EventCategory EnumType
 * @subpackage Enumerations
 */
class EventCategory
{
    /**
     * Constant for value 'Conference'
     * @return string 'Conference'
     */
    const VALUE_CONFERENCE = 'Conference';
    /**
     * Constant for value 'Meeting'
     * @return string 'Meeting'
     */
    const VALUE_MEETING = 'Meeting';
    /**
     * Constant for value 'Seminar'
     * @return string 'Seminar'
     */
    const VALUE_SEMINAR = 'Seminar';
    /**
     * Constant for value 'Training Session'
     * @return string 'Training Session'
     */
    const VALUE_TRAINING_SESSION = 'Training Session';
    /**
     * Constant for value 'Trade Show'
     * @return string 'Trade Show'
     */
    const VALUE_TRADE_SHOW = 'Trade Show';
    /**
     * Constant for value 'Dinner'
     * @return string 'Dinner'
     */
    const VALUE_DINNER = 'Dinner';
    /**
     * Constant for value 'Political Event'
     * @return string 'Political Event'
     */
    const VALUE_POLITICAL_EVENT = 'Political Event';
    /**
     * Constant for value 'Forum'
     * @return string 'Forum'
     */
    const VALUE_FORUM = 'Forum';
    /**
     * Constant for value 'Fundraiser/Benefit'
     * @return string 'Fundraiser/Benefit'
     */
    const VALUE_FUNDRAISER_BENEFIT = 'Fundraiser/Benefit';
    /**
     * Constant for value 'Save the Date'
     * @return string 'Save the Date'
     */
    const VALUE_SAVE_THE_DATE = 'Save the Date';
    /**
     * Constant for value 'Celebration'
     * @return string 'Celebration'
     */
    const VALUE_CELEBRATION = 'Celebration';
    /**
     * Constant for value 'Holiday'
     * @return string 'Holiday'
     */
    const VALUE_HOLIDAY = 'Holiday';
    /**
     * Constant for value 'Reunion'
     * @return string 'Reunion'
     */
    const VALUE_REUNION = 'Reunion';
    /**
     * Constant for value 'Sports Event'
     * @return string 'Sports Event'
     */
    const VALUE_SPORTS_EVENT = 'Sports Event';
    /**
     * Constant for value 'Other/General'
     * @return string 'Other/General'
     */
    const VALUE_OTHER_GENERAL = 'Other/General';
    /**
     * Constant for value 'Incentive Trip'
     * @return string 'Incentive Trip'
     */
    const VALUE_INCENTIVE_TRIP = 'Incentive Trip';
    /**
     * Constant for value 'Webinar'
     * @return string 'Webinar'
     */
    const VALUE_WEBINAR = 'Webinar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONFERENCE
     * @uses self::VALUE_MEETING
     * @uses self::VALUE_SEMINAR
     * @uses self::VALUE_TRAINING_SESSION
     * @uses self::VALUE_TRADE_SHOW
     * @uses self::VALUE_DINNER
     * @uses self::VALUE_POLITICAL_EVENT
     * @uses self::VALUE_FORUM
     * @uses self::VALUE_FUNDRAISER_BENEFIT
     * @uses self::VALUE_SAVE_THE_DATE
     * @uses self::VALUE_CELEBRATION
     * @uses self::VALUE_HOLIDAY
     * @uses self::VALUE_REUNION
     * @uses self::VALUE_SPORTS_EVENT
     * @uses self::VALUE_OTHER_GENERAL
     * @uses self::VALUE_INCENTIVE_TRIP
     * @uses self::VALUE_WEBINAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONFERENCE,
            self::VALUE_MEETING,
            self::VALUE_SEMINAR,
            self::VALUE_TRAINING_SESSION,
            self::VALUE_TRADE_SHOW,
            self::VALUE_DINNER,
            self::VALUE_POLITICAL_EVENT,
            self::VALUE_FORUM,
            self::VALUE_FUNDRAISER_BENEFIT,
            self::VALUE_SAVE_THE_DATE,
            self::VALUE_CELEBRATION,
            self::VALUE_HOLIDAY,
            self::VALUE_REUNION,
            self::VALUE_SPORTS_EVENT,
            self::VALUE_OTHER_GENERAL,
            self::VALUE_INCENTIVE_TRIP,
            self::VALUE_WEBINAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
