<?php

namespace EnumType;

/**
 * This class stands for EmailTemplate EnumType
 * @subpackage Enumerations
 */
class EmailTemplate
{
    /**
     * Constant for value 'Invitation'
     * @return string 'Invitation'
     */
    const VALUE_INVITATION = 'Invitation';
    /**
     * Constant for value 'CustomInviteeMessage'
     * @return string 'CustomInviteeMessage'
     */
    const VALUE_CUSTOM_INVITEE_MESSAGE = 'CustomInviteeMessage';
    /**
     * Constant for value 'InvitationReminder'
     * @return string 'InvitationReminder'
     */
    const VALUE_INVITATION_REMINDER = 'InvitationReminder';
    /**
     * Constant for value 'CustomUndecidedMessage'
     * @return string 'CustomUndecidedMessage'
     */
    const VALUE_CUSTOM_UNDECIDED_MESSAGE = 'CustomUndecidedMessage';
    /**
     * Constant for value 'RegistrationConfirmation'
     * @return string 'RegistrationConfirmation'
     */
    const VALUE_REGISTRATION_CONFIRMATION = 'RegistrationConfirmation';
    /**
     * Constant for value 'EventReminder'
     * @return string 'EventReminder'
     */
    const VALUE_EVENT_REMINDER = 'EventReminder';
    /**
     * Constant for value 'CustomAttendeeMessage'
     * @return string 'CustomAttendeeMessage'
     */
    const VALUE_CUSTOM_ATTENDEE_MESSAGE = 'CustomAttendeeMessage';
    /**
     * Constant for value 'ModificationConfirmation'
     * @return string 'ModificationConfirmation'
     */
    const VALUE_MODIFICATION_CONFIRMATION = 'ModificationConfirmation';
    /**
     * Constant for value 'CancellationConfirmation'
     * @return string 'CancellationConfirmation'
     */
    const VALUE_CANCELLATION_CONFIRMATION = 'CancellationConfirmation';
    /**
     * Constant for value 'Regret'
     * @return string 'Regret'
     */
    const VALUE_REGRET = 'Regret';
    /**
     * Constant for value 'CustomDeclineeMessage'
     * @return string 'CustomDeclineeMessage'
     */
    const VALUE_CUSTOM_DECLINEE_MESSAGE = 'CustomDeclineeMessage';
    /**
     * Constant for value 'PostEventFollowUp'
     * @return string 'PostEventFollowUp'
     */
    const VALUE_POST_EVENT_FOLLOW_UP = 'PostEventFollowUp';
    /**
     * Constant for value 'CustomAttendedMessage'
     * @return string 'CustomAttendedMessage'
     */
    const VALUE_CUSTOM_ATTENDED_MESSAGE = 'CustomAttendedMessage';
    /**
     * Constant for value 'ApprovalDenied'
     * @return string 'ApprovalDenied'
     */
    const VALUE_APPROVAL_DENIED = 'ApprovalDenied';
    /**
     * Constant for value 'ApprovalPending'
     * @return string 'ApprovalPending'
     */
    const VALUE_APPROVAL_PENDING = 'ApprovalPending';
    /**
     * Constant for value 'CustomEmail'
     * @return string 'CustomEmail'
     */
    const VALUE_CUSTOM_EMAIL = 'CustomEmail';
    /**
     * Constant for value 'SurveyInvitation'
     * @return string 'SurveyInvitation'
     */
    const VALUE_SURVEY_INVITATION = 'SurveyInvitation';
    /**
     * Constant for value 'SurveyCustomInviteeMessage'
     * @return string 'SurveyCustomInviteeMessage'
     */
    const VALUE_SURVEY_CUSTOM_INVITEE_MESSAGE = 'SurveyCustomInviteeMessage';
    /**
     * Constant for value 'SurveyReminder'
     * @return string 'SurveyReminder'
     */
    const VALUE_SURVEY_REMINDER = 'SurveyReminder';
    /**
     * Constant for value 'SurveyCustomNoResponseMessage'
     * @return string 'SurveyCustomNoResponseMessage'
     */
    const VALUE_SURVEY_CUSTOM_NO_RESPONSE_MESSAGE = 'SurveyCustomNoResponseMessage';
    /**
     * Constant for value 'SurveyPartiallyCompleteMessage'
     * @return string 'SurveyPartiallyCompleteMessage'
     */
    const VALUE_SURVEY_PARTIALLY_COMPLETE_MESSAGE = 'SurveyPartiallyCompleteMessage';
    /**
     * Constant for value 'SurveyCustomMessageToPartials'
     * @return string 'SurveyCustomMessageToPartials'
     */
    const VALUE_SURVEY_CUSTOM_MESSAGE_TO_PARTIALS = 'SurveyCustomMessageToPartials';
    /**
     * Constant for value 'SurveyCompletionMessage'
     * @return string 'SurveyCompletionMessage'
     */
    const VALUE_SURVEY_COMPLETION_MESSAGE = 'SurveyCompletionMessage';
    /**
     * Constant for value 'SurveyCustomMessageToRespondents'
     * @return string 'SurveyCustomMessageToRespondents'
     */
    const VALUE_SURVEY_CUSTOM_MESSAGE_TO_RESPONDENTS = 'SurveyCustomMessageToRespondents';
    /**
     * Constant for value 'SurveyCustomEmail'
     * @return string 'SurveyCustomEmail'
     */
    const VALUE_SURVEY_CUSTOM_EMAIL = 'SurveyCustomEmail';
    /**
     * Constant for value 'SurveyInvitationWithQuestion'
     * @return string 'SurveyInvitationWithQuestion'
     */
    const VALUE_SURVEY_INVITATION_WITH_QUESTION = 'SurveyInvitationWithQuestion';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INVITATION
     * @uses self::VALUE_CUSTOM_INVITEE_MESSAGE
     * @uses self::VALUE_INVITATION_REMINDER
     * @uses self::VALUE_CUSTOM_UNDECIDED_MESSAGE
     * @uses self::VALUE_REGISTRATION_CONFIRMATION
     * @uses self::VALUE_EVENT_REMINDER
     * @uses self::VALUE_CUSTOM_ATTENDEE_MESSAGE
     * @uses self::VALUE_MODIFICATION_CONFIRMATION
     * @uses self::VALUE_CANCELLATION_CONFIRMATION
     * @uses self::VALUE_REGRET
     * @uses self::VALUE_CUSTOM_DECLINEE_MESSAGE
     * @uses self::VALUE_POST_EVENT_FOLLOW_UP
     * @uses self::VALUE_CUSTOM_ATTENDED_MESSAGE
     * @uses self::VALUE_APPROVAL_DENIED
     * @uses self::VALUE_APPROVAL_PENDING
     * @uses self::VALUE_CUSTOM_EMAIL
     * @uses self::VALUE_SURVEY_INVITATION
     * @uses self::VALUE_SURVEY_CUSTOM_INVITEE_MESSAGE
     * @uses self::VALUE_SURVEY_REMINDER
     * @uses self::VALUE_SURVEY_CUSTOM_NO_RESPONSE_MESSAGE
     * @uses self::VALUE_SURVEY_PARTIALLY_COMPLETE_MESSAGE
     * @uses self::VALUE_SURVEY_CUSTOM_MESSAGE_TO_PARTIALS
     * @uses self::VALUE_SURVEY_COMPLETION_MESSAGE
     * @uses self::VALUE_SURVEY_CUSTOM_MESSAGE_TO_RESPONDENTS
     * @uses self::VALUE_SURVEY_CUSTOM_EMAIL
     * @uses self::VALUE_SURVEY_INVITATION_WITH_QUESTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVITATION,
            self::VALUE_CUSTOM_INVITEE_MESSAGE,
            self::VALUE_INVITATION_REMINDER,
            self::VALUE_CUSTOM_UNDECIDED_MESSAGE,
            self::VALUE_REGISTRATION_CONFIRMATION,
            self::VALUE_EVENT_REMINDER,
            self::VALUE_CUSTOM_ATTENDEE_MESSAGE,
            self::VALUE_MODIFICATION_CONFIRMATION,
            self::VALUE_CANCELLATION_CONFIRMATION,
            self::VALUE_REGRET,
            self::VALUE_CUSTOM_DECLINEE_MESSAGE,
            self::VALUE_POST_EVENT_FOLLOW_UP,
            self::VALUE_CUSTOM_ATTENDED_MESSAGE,
            self::VALUE_APPROVAL_DENIED,
            self::VALUE_APPROVAL_PENDING,
            self::VALUE_CUSTOM_EMAIL,
            self::VALUE_SURVEY_INVITATION,
            self::VALUE_SURVEY_CUSTOM_INVITEE_MESSAGE,
            self::VALUE_SURVEY_REMINDER,
            self::VALUE_SURVEY_CUSTOM_NO_RESPONSE_MESSAGE,
            self::VALUE_SURVEY_PARTIALLY_COMPLETE_MESSAGE,
            self::VALUE_SURVEY_CUSTOM_MESSAGE_TO_PARTIALS,
            self::VALUE_SURVEY_COMPLETION_MESSAGE,
            self::VALUE_SURVEY_CUSTOM_MESSAGE_TO_RESPONDENTS,
            self::VALUE_SURVEY_CUSTOM_EMAIL,
            self::VALUE_SURVEY_INVITATION_WITH_QUESTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
