<?php

namespace EnumType;

/**
 * This class stands for CvVisibilityType EnumType
 * @subpackage Enumerations
 */
class CvVisibilityType
{
    /**
     * Constant for value 'Event'
     * @return string 'Event'
     */
    const VALUE_EVENT = 'Event';
    /**
     * Constant for value 'Survey'
     * @return string 'Survey'
     */
    const VALUE_SURVEY = 'Survey';
    /**
     * Constant for value 'RFP'
     * @return string 'RFP'
     */
    const VALUE_RFP = 'RFP';
    /**
     * Constant for value 'Campaign'
     * @return string 'Campaign'
     */
    const VALUE_CAMPAIGN = 'Campaign';
    /**
     * Constant for value 'Meeting Requests'
     * @return string 'Meeting Requests'
     */
    const VALUE_MEETING_REQUESTS = 'Meeting Requests';
    /**
     * Constant for value 'RFI'
     * @return string 'RFI'
     */
    const VALUE_RFI = 'RFI';
    /**
     * Constant for value 'Document Security'
     * @return string 'Document Security'
     */
    const VALUE_DOCUMENT_SECURITY = 'Document Security';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EVENT
     * @uses self::VALUE_SURVEY
     * @uses self::VALUE_RFP
     * @uses self::VALUE_CAMPAIGN
     * @uses self::VALUE_MEETING_REQUESTS
     * @uses self::VALUE_RFI
     * @uses self::VALUE_DOCUMENT_SECURITY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EVENT,
            self::VALUE_SURVEY,
            self::VALUE_RFP,
            self::VALUE_CAMPAIGN,
            self::VALUE_MEETING_REQUESTS,
            self::VALUE_RFI,
            self::VALUE_DOCUMENT_SECURITY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
