<?php

namespace EnumType;

/**
 * This class stands for CvUserType EnumType
 * @subpackage Enumerations
 */
class CvUserType
{
    /**
     * Constant for value 'Application'
     * @return string 'Application'
     */
    const VALUE_APPLICATION = 'Application';
    /**
     * Constant for value 'Requester'
     * @return string 'Requester'
     */
    const VALUE_REQUESTER = 'Requester';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPLICATION
     * @uses self::VALUE_REQUESTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPLICATION,
            self::VALUE_REQUESTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
