<?php

namespace EnumType;

/**
 * This class stands for CvSearchType EnumType
 * @subpackage Enumerations
 */
class CvSearchType
{
    /**
     * Constant for value 'AndSearch'
     * @return string 'AndSearch'
     */
    const VALUE_AND_SEARCH = 'AndSearch';
    /**
     * Constant for value 'OrSearch'
     * @return string 'OrSearch'
     */
    const VALUE_OR_SEARCH = 'OrSearch';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AND_SEARCH
     * @uses self::VALUE_OR_SEARCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AND_SEARCH,
            self::VALUE_OR_SEARCH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
