<?php

namespace EnumType;

/**
 * This class stands for CvSearchOperatorType EnumType
 * @subpackage Enumerations
 */
class CvSearchOperatorType
{
    /**
     * Constant for value 'Equals'
     * @return string 'Equals'
     */
    const VALUE_EQUALS = 'Equals';
    /**
     * Constant for value 'Not Equal to'
     * @return string 'Not Equal to'
     */
    const VALUE_NOT_EQUAL_TO = 'Not Equal to';
    /**
     * Constant for value 'Less than'
     * @return string 'Less than'
     */
    const VALUE_LESS_THAN = 'Less than';
    /**
     * Constant for value 'Greater than'
     * @return string 'Greater than'
     */
    const VALUE_GREATER_THAN = 'Greater than';
    /**
     * Constant for value 'Less than or Equal to'
     * @return string 'Less than or Equal to'
     */
    const VALUE_LESS_THAN_OR_EQUAL_TO = 'Less than or Equal to';
    /**
     * Constant for value 'Greater than or Equal to'
     * @return string 'Greater than or Equal to'
     */
    const VALUE_GREATER_THAN_OR_EQUAL_TO = 'Greater than or Equal to';
    /**
     * Constant for value 'Contains'
     * @return string 'Contains'
     */
    const VALUE_CONTAINS = 'Contains';
    /**
     * Constant for value 'Does not Contain'
     * @return string 'Does not Contain'
     */
    const VALUE_DOES_NOT_CONTAIN = 'Does not Contain';
    /**
     * Constant for value 'Starts with'
     * @return string 'Starts with'
     */
    const VALUE_STARTS_WITH = 'Starts with';
    /**
     * Constant for value 'Includes'
     * @return string 'Includes'
     */
    const VALUE_INCLUDES = 'Includes';
    /**
     * Constant for value 'Excludes'
     * @return string 'Excludes'
     */
    const VALUE_EXCLUDES = 'Excludes';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUALS
     * @uses self::VALUE_NOT_EQUAL_TO
     * @uses self::VALUE_LESS_THAN
     * @uses self::VALUE_GREATER_THAN
     * @uses self::VALUE_LESS_THAN_OR_EQUAL_TO
     * @uses self::VALUE_GREATER_THAN_OR_EQUAL_TO
     * @uses self::VALUE_CONTAINS
     * @uses self::VALUE_DOES_NOT_CONTAIN
     * @uses self::VALUE_STARTS_WITH
     * @uses self::VALUE_INCLUDES
     * @uses self::VALUE_EXCLUDES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUALS,
            self::VALUE_NOT_EQUAL_TO,
            self::VALUE_LESS_THAN,
            self::VALUE_GREATER_THAN,
            self::VALUE_LESS_THAN_OR_EQUAL_TO,
            self::VALUE_GREATER_THAN_OR_EQUAL_TO,
            self::VALUE_CONTAINS,
            self::VALUE_DOES_NOT_CONTAIN,
            self::VALUE_STARTS_WITH,
            self::VALUE_INCLUDES,
            self::VALUE_EXCLUDES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
