<?php

namespace EnumType;

/**
 * This class stands for CvObjectType EnumType
 * @subpackage Enumerations
 */
class CvObjectType
{
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Constant for value 'Event'
     * @return string 'Event'
     */
    const VALUE_EVENT = 'Event';
    /**
     * Constant for value 'Invitee'
     * @return string 'Invitee'
     */
    const VALUE_INVITEE = 'Invitee';
    /**
     * Constant for value 'Registration'
     * @return string 'Registration'
     */
    const VALUE_REGISTRATION = 'Registration';
    /**
     * Constant for value 'Respondent'
     * @return string 'Respondent'
     */
    const VALUE_RESPONDENT = 'Respondent';
    /**
     * Constant for value 'Response'
     * @return string 'Response'
     */
    const VALUE_RESPONSE = 'Response';
    /**
     * Constant for value 'Survey'
     * @return string 'Survey'
     */
    const VALUE_SURVEY = 'Survey';
    /**
     * Constant for value 'Transaction'
     * @return string 'Transaction'
     */
    const VALUE_TRANSACTION = 'Transaction';
    /**
     * Constant for value 'Travel'
     * @return string 'Travel'
     */
    const VALUE_TRAVEL = 'Travel';
    /**
     * Constant for value 'ContactGroup'
     * @return string 'ContactGroup'
     */
    const VALUE_CONTACT_GROUP = 'ContactGroup';
    /**
     * Constant for value 'EventEmailHistory'
     * @return string 'EventEmailHistory'
     */
    const VALUE_EVENT_EMAIL_HISTORY = 'EventEmailHistory';
    /**
     * Constant for value 'Budget'
     * @return string 'Budget'
     */
    const VALUE_BUDGET = 'Budget';
    /**
     * Constant for value 'BudgetItem'
     * @return string 'BudgetItem'
     */
    const VALUE_BUDGET_ITEM = 'BudgetItem';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'UserGroup'
     * @return string 'UserGroup'
     */
    const VALUE_USER_GROUP = 'UserGroup';
    /**
     * Constant for value 'UserRole'
     * @return string 'UserRole'
     */
    const VALUE_USER_ROLE = 'UserRole';
    /**
     * Constant for value 'MeetingRequestUser'
     * @return string 'MeetingRequestUser'
     */
    const VALUE_MEETING_REQUEST_USER = 'MeetingRequestUser';
    /**
     * Constant for value 'MeetingRequest'
     * @return string 'MeetingRequest'
     */
    const VALUE_MEETING_REQUEST = 'MeetingRequest';
    /**
     * Constant for value 'RFP'
     * @return string 'RFP'
     */
    const VALUE_RFP = 'RFP';
    /**
     * Constant for value 'Proposal'
     * @return string 'Proposal'
     */
    const VALUE_PROPOSAL = 'Proposal';
    /**
     * Constant for value 'SupplierRFP'
     * @return string 'SupplierRFP'
     */
    const VALUE_SUPPLIER_RFP = 'SupplierRFP';
    /**
     * Constant for value 'SupplierProposal'
     * @return string 'SupplierProposal'
     */
    const VALUE_SUPPLIER_PROPOSAL = 'SupplierProposal';
    /**
     * Constant for value 'RateHistory'
     * @return string 'RateHistory'
     */
    const VALUE_RATE_HISTORY = 'RateHistory';
    /**
     * Constant for value 'EventQuestion'
     * @return string 'EventQuestion'
     */
    const VALUE_EVENT_QUESTION = 'EventQuestion';
    /**
     * Constant for value 'SurveyEmailHistory'
     * @return string 'SurveyEmailHistory'
     */
    const VALUE_SURVEY_EMAIL_HISTORY = 'SurveyEmailHistory';
    /**
     * Constant for value 'Supplier'
     * @return string 'Supplier'
     */
    const VALUE_SUPPLIER = 'Supplier';
    /**
     * Constant for value 'EventDetail'
     * @return string 'EventDetail'
     */
    const VALUE_EVENT_DETAIL = 'EventDetail';
    /**
     * Constant for value 'Guest'
     * @return string 'Guest'
     */
    const VALUE_GUEST = 'Guest';
    /**
     * Constant for value 'Campaign'
     * @return string 'Campaign'
     */
    const VALUE_CAMPAIGN = 'Campaign';
    /**
     * Constant for value 'DistributionList'
     * @return string 'DistributionList'
     */
    const VALUE_DISTRIBUTION_LIST = 'DistributionList';
    /**
     * Constant for value 'EMarketingEmailHistory'
     * @return string 'EMarketingEmailHistory'
     */
    const VALUE_EMARKETING_EMAIL_HISTORY = 'EMarketingEmailHistory';
    /**
     * Constant for value 'Approver'
     * @return string 'Approver'
     */
    const VALUE_APPROVER = 'Approver';
    /**
     * Constant for value 'SurveyQuestion'
     * @return string 'SurveyQuestion'
     */
    const VALUE_SURVEY_QUESTION = 'SurveyQuestion';
    /**
     * Constant for value 'Appointment'
     * @return string 'Appointment'
     */
    const VALUE_APPOINTMENT = 'Appointment';
    /**
     * Constant for value 'AppointmentAttendee'
     * @return string 'AppointmentAttendee'
     */
    const VALUE_APPOINTMENT_ATTENDEE = 'AppointmentAttendee';
    /**
     * Constant for value 'Speaker'
     * @return string 'Speaker'
     */
    const VALUE_SPEAKER = 'Speaker';
    /**
     * Constant for value 'TableAssignment'
     * @return string 'TableAssignment'
     */
    const VALUE_TABLE_ASSIGNMENT = 'TableAssignment';
    /**
     * Constant for value 'ConversionRate'
     * @return string 'ConversionRate'
     */
    const VALUE_CONVERSION_RATE = 'ConversionRate';
    /**
     * Constant for value 'EventCards'
     * @return string 'EventCards'
     */
    const VALUE_EVENT_CARDS = 'EventCards';
    /**
     * Constant for value 'Session'
     * @return string 'Session'
     */
    const VALUE_SESSION = 'Session';
    /**
     * Constant for value 'EntityCustomField'
     * @return string 'EntityCustomField'
     */
    const VALUE_ENTITY_CUSTOM_FIELD = 'EntityCustomField';
    /**
     * Constant for value 'AdvancedLogic'
     * @return string 'AdvancedLogic'
     */
    const VALUE_ADVANCED_LOGIC = 'AdvancedLogic';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_EVENT
     * @uses self::VALUE_INVITEE
     * @uses self::VALUE_REGISTRATION
     * @uses self::VALUE_RESPONDENT
     * @uses self::VALUE_RESPONSE
     * @uses self::VALUE_SURVEY
     * @uses self::VALUE_TRANSACTION
     * @uses self::VALUE_TRAVEL
     * @uses self::VALUE_CONTACT_GROUP
     * @uses self::VALUE_EVENT_EMAIL_HISTORY
     * @uses self::VALUE_BUDGET
     * @uses self::VALUE_BUDGET_ITEM
     * @uses self::VALUE_USER
     * @uses self::VALUE_USER_GROUP
     * @uses self::VALUE_USER_ROLE
     * @uses self::VALUE_MEETING_REQUEST_USER
     * @uses self::VALUE_MEETING_REQUEST
     * @uses self::VALUE_RFP
     * @uses self::VALUE_PROPOSAL
     * @uses self::VALUE_SUPPLIER_RFP
     * @uses self::VALUE_SUPPLIER_PROPOSAL
     * @uses self::VALUE_RATE_HISTORY
     * @uses self::VALUE_EVENT_QUESTION
     * @uses self::VALUE_SURVEY_EMAIL_HISTORY
     * @uses self::VALUE_SUPPLIER
     * @uses self::VALUE_EVENT_DETAIL
     * @uses self::VALUE_GUEST
     * @uses self::VALUE_CAMPAIGN
     * @uses self::VALUE_DISTRIBUTION_LIST
     * @uses self::VALUE_EMARKETING_EMAIL_HISTORY
     * @uses self::VALUE_APPROVER
     * @uses self::VALUE_SURVEY_QUESTION
     * @uses self::VALUE_APPOINTMENT
     * @uses self::VALUE_APPOINTMENT_ATTENDEE
     * @uses self::VALUE_SPEAKER
     * @uses self::VALUE_TABLE_ASSIGNMENT
     * @uses self::VALUE_CONVERSION_RATE
     * @uses self::VALUE_EVENT_CARDS
     * @uses self::VALUE_SESSION
     * @uses self::VALUE_ENTITY_CUSTOM_FIELD
     * @uses self::VALUE_ADVANCED_LOGIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTACT,
            self::VALUE_EVENT,
            self::VALUE_INVITEE,
            self::VALUE_REGISTRATION,
            self::VALUE_RESPONDENT,
            self::VALUE_RESPONSE,
            self::VALUE_SURVEY,
            self::VALUE_TRANSACTION,
            self::VALUE_TRAVEL,
            self::VALUE_CONTACT_GROUP,
            self::VALUE_EVENT_EMAIL_HISTORY,
            self::VALUE_BUDGET,
            self::VALUE_BUDGET_ITEM,
            self::VALUE_USER,
            self::VALUE_USER_GROUP,
            self::VALUE_USER_ROLE,
            self::VALUE_MEETING_REQUEST_USER,
            self::VALUE_MEETING_REQUEST,
            self::VALUE_RFP,
            self::VALUE_PROPOSAL,
            self::VALUE_SUPPLIER_RFP,
            self::VALUE_SUPPLIER_PROPOSAL,
            self::VALUE_RATE_HISTORY,
            self::VALUE_EVENT_QUESTION,
            self::VALUE_SURVEY_EMAIL_HISTORY,
            self::VALUE_SUPPLIER,
            self::VALUE_EVENT_DETAIL,
            self::VALUE_GUEST,
            self::VALUE_CAMPAIGN,
            self::VALUE_DISTRIBUTION_LIST,
            self::VALUE_EMARKETING_EMAIL_HISTORY,
            self::VALUE_APPROVER,
            self::VALUE_SURVEY_QUESTION,
            self::VALUE_APPOINTMENT,
            self::VALUE_APPOINTMENT_ATTENDEE,
            self::VALUE_SPEAKER,
            self::VALUE_TABLE_ASSIGNMENT,
            self::VALUE_CONVERSION_RATE,
            self::VALUE_EVENT_CARDS,
            self::VALUE_SESSION,
            self::VALUE_ENTITY_CUSTOM_FIELD,
            self::VALUE_ADVANCED_LOGIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
