<?php

namespace EnumType;

/**
 * This class stands for CvCustomFieldEntityType EnumType
 * @subpackage Enumerations
 */
class CvCustomFieldEntityType
{
    /**
     * Constant for value 'AppointmentCustomField'
     * @return string 'AppointmentCustomField'
     */
    const VALUE_APPOINTMENT_CUSTOM_FIELD = 'AppointmentCustomField';
    /**
     * Constant for value 'BudgetItemCustomField'
     * @return string 'BudgetItemCustomField'
     */
    const VALUE_BUDGET_ITEM_CUSTOM_FIELD = 'BudgetItemCustomField';
    /**
     * Constant for value 'CampaignCustomField'
     * @return string 'CampaignCustomField'
     */
    const VALUE_CAMPAIGN_CUSTOM_FIELD = 'CampaignCustomField';
    /**
     * Constant for value 'ContactCustomField'
     * @return string 'ContactCustomField'
     */
    const VALUE_CONTACT_CUSTOM_FIELD = 'ContactCustomField';
    /**
     * Constant for value 'EventCustomField'
     * @return string 'EventCustomField'
     */
    const VALUE_EVENT_CUSTOM_FIELD = 'EventCustomField';
    /**
     * Constant for value 'ResourceCustomField'
     * @return string 'ResourceCustomField'
     */
    const VALUE_RESOURCE_CUSTOM_FIELD = 'ResourceCustomField';
    /**
     * Constant for value 'RFPCustomField'
     * @return string 'RFPCustomField'
     */
    const VALUE_RFPCUSTOM_FIELD = 'RFPCustomField';
    /**
     * Constant for value 'SessionCustomField'
     * @return string 'SessionCustomField'
     */
    const VALUE_SESSION_CUSTOM_FIELD = 'SessionCustomField';
    /**
     * Constant for value 'SurveyCustomField'
     * @return string 'SurveyCustomField'
     */
    const VALUE_SURVEY_CUSTOM_FIELD = 'SurveyCustomField';
    /**
     * Constant for value 'UserCustomField'
     * @return string 'UserCustomField'
     */
    const VALUE_USER_CUSTOM_FIELD = 'UserCustomField';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPOINTMENT_CUSTOM_FIELD
     * @uses self::VALUE_BUDGET_ITEM_CUSTOM_FIELD
     * @uses self::VALUE_CAMPAIGN_CUSTOM_FIELD
     * @uses self::VALUE_CONTACT_CUSTOM_FIELD
     * @uses self::VALUE_EVENT_CUSTOM_FIELD
     * @uses self::VALUE_RESOURCE_CUSTOM_FIELD
     * @uses self::VALUE_RFPCUSTOM_FIELD
     * @uses self::VALUE_SESSION_CUSTOM_FIELD
     * @uses self::VALUE_SURVEY_CUSTOM_FIELD
     * @uses self::VALUE_USER_CUSTOM_FIELD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPOINTMENT_CUSTOM_FIELD,
            self::VALUE_BUDGET_ITEM_CUSTOM_FIELD,
            self::VALUE_CAMPAIGN_CUSTOM_FIELD,
            self::VALUE_CONTACT_CUSTOM_FIELD,
            self::VALUE_EVENT_CUSTOM_FIELD,
            self::VALUE_RESOURCE_CUSTOM_FIELD,
            self::VALUE_RFPCUSTOM_FIELD,
            self::VALUE_SESSION_CUSTOM_FIELD,
            self::VALUE_SURVEY_CUSTOM_FIELD,
            self::VALUE_USER_CUSTOM_FIELD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
