<?php

namespace EnumType;

/**
 * This class stands for ActivityType EnumType
 * @subpackage Enumerations
 */
class ActivityType
{
    /**
     * Constant for value 'Event'
     * @return string 'Event'
     */
    const VALUE_EVENT = 'Event';
    /**
     * Constant for value 'Survey'
     * @return string 'Survey'
     */
    const VALUE_SURVEY = 'Survey';
    /**
     * Constant for value 'Campaigns'
     * @return string 'Campaigns'
     */
    const VALUE_CAMPAIGNS = 'Campaigns';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EVENT
     * @uses self::VALUE_SURVEY
     * @uses self::VALUE_CAMPAIGNS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EVENT,
            self::VALUE_SURVEY,
            self::VALUE_CAMPAIGNS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
