<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for SendEmailResultArray ArrayType
 * @subpackage Arrays
 */
class SendEmailResultArray extends AbstractStructArrayBase
{
    /**
     * The SendEmailResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SendEmailResult[]
     */
    public $SendEmailResult;
    /**
     * Constructor method for SendEmailResultArray
     * @uses SendEmailResultArray::setSendEmailResult()
     * @param \StructType\SendEmailResult[] $sendEmailResult
     */
    public function __construct(array $sendEmailResult = array())
    {
        $this
            ->setSendEmailResult($sendEmailResult);
    }
    /**
     * Get SendEmailResult value
     * @return \StructType\SendEmailResult[]|null
     */
    public function getSendEmailResult()
    {
        return $this->SendEmailResult;
    }
    /**
     * This method is responsible for validating the values passed to the setSendEmailResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSendEmailResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSendEmailResultForArrayConstraintsFromSetSendEmailResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendEmailResultArraySendEmailResultItem) {
            // validation for constraint: itemType
            if (!$sendEmailResultArraySendEmailResultItem instanceof \StructType\SendEmailResult) {
                $invalidValues[] = is_object($sendEmailResultArraySendEmailResultItem) ? get_class($sendEmailResultArraySendEmailResultItem) : sprintf('%s(%s)', gettype($sendEmailResultArraySendEmailResultItem), var_export($sendEmailResultArraySendEmailResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SendEmailResult property can only contain items of type \StructType\SendEmailResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SendEmailResult value
     * @throws \InvalidArgumentException
     * @param \StructType\SendEmailResult[] $sendEmailResult
     * @return \ArrayType\SendEmailResultArray
     */
    public function setSendEmailResult(array $sendEmailResult = array())
    {
        // validation for constraint: array
        if ('' !== ($sendEmailResultArrayErrorMessage = self::validateSendEmailResultForArrayConstraintsFromSetSendEmailResult($sendEmailResult))) {
            throw new \InvalidArgumentException($sendEmailResultArrayErrorMessage, __LINE__);
        }
        $this->SendEmailResult = $sendEmailResult;
        return $this;
    }
    /**
     * Add item to SendEmailResult value
     * @throws \InvalidArgumentException
     * @param \StructType\SendEmailResult $item
     * @return \ArrayType\SendEmailResultArray
     */
    public function addToSendEmailResult(\StructType\SendEmailResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SendEmailResult) {
            throw new \InvalidArgumentException(sprintf('The SendEmailResult property can only contain items of type \StructType\SendEmailResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SendEmailResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SendEmailResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SendEmailResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SendEmailResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SendEmailResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SendEmailResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SendEmailResult
     */
    public function getAttributeName()
    {
        return 'SendEmailResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\SendEmailResultArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
