<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for DeleteUserResultArray ArrayType
 * @subpackage Arrays
 */
class DeleteUserResultArray extends AbstractStructArrayBase
{
    /**
     * The DeleteUserResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DeleteUserResult[]
     */
    public $DeleteUserResult;
    /**
     * Constructor method for DeleteUserResultArray
     * @uses DeleteUserResultArray::setDeleteUserResult()
     * @param \StructType\DeleteUserResult[] $deleteUserResult
     */
    public function __construct(array $deleteUserResult = array())
    {
        $this
            ->setDeleteUserResult($deleteUserResult);
    }
    /**
     * Get DeleteUserResult value
     * @return \StructType\DeleteUserResult[]|null
     */
    public function getDeleteUserResult()
    {
        return $this->DeleteUserResult;
    }
    /**
     * This method is responsible for validating the values passed to the setDeleteUserResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeleteUserResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeleteUserResultForArrayConstraintsFromSetDeleteUserResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteUserResultArrayDeleteUserResultItem) {
            // validation for constraint: itemType
            if (!$deleteUserResultArrayDeleteUserResultItem instanceof \StructType\DeleteUserResult) {
                $invalidValues[] = is_object($deleteUserResultArrayDeleteUserResultItem) ? get_class($deleteUserResultArrayDeleteUserResultItem) : sprintf('%s(%s)', gettype($deleteUserResultArrayDeleteUserResultItem), var_export($deleteUserResultArrayDeleteUserResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeleteUserResult property can only contain items of type \StructType\DeleteUserResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeleteUserResult value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteUserResult[] $deleteUserResult
     * @return \ArrayType\DeleteUserResultArray
     */
    public function setDeleteUserResult(array $deleteUserResult = array())
    {
        // validation for constraint: array
        if ('' !== ($deleteUserResultArrayErrorMessage = self::validateDeleteUserResultForArrayConstraintsFromSetDeleteUserResult($deleteUserResult))) {
            throw new \InvalidArgumentException($deleteUserResultArrayErrorMessage, __LINE__);
        }
        $this->DeleteUserResult = $deleteUserResult;
        return $this;
    }
    /**
     * Add item to DeleteUserResult value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteUserResult $item
     * @return \ArrayType\DeleteUserResultArray
     */
    public function addToDeleteUserResult(\StructType\DeleteUserResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteUserResult) {
            throw new \InvalidArgumentException(sprintf('The DeleteUserResult property can only contain items of type \StructType\DeleteUserResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeleteUserResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteUserResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteUserResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteUserResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteUserResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteUserResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteUserResult
     */
    public function getAttributeName()
    {
        return 'DeleteUserResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\DeleteUserResultArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
