<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for DeleteBudgetItemResultArray ArrayType
 * @subpackage Arrays
 */
class DeleteBudgetItemResultArray extends AbstractStructArrayBase
{
    /**
     * The DeleteBudgetItemResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DeleteBudgetItemResult[]
     */
    public $DeleteBudgetItemResult;
    /**
     * Constructor method for DeleteBudgetItemResultArray
     * @uses DeleteBudgetItemResultArray::setDeleteBudgetItemResult()
     * @param \StructType\DeleteBudgetItemResult[] $deleteBudgetItemResult
     */
    public function __construct(array $deleteBudgetItemResult = array())
    {
        $this
            ->setDeleteBudgetItemResult($deleteBudgetItemResult);
    }
    /**
     * Get DeleteBudgetItemResult value
     * @return \StructType\DeleteBudgetItemResult[]|null
     */
    public function getDeleteBudgetItemResult()
    {
        return $this->DeleteBudgetItemResult;
    }
    /**
     * This method is responsible for validating the values passed to the setDeleteBudgetItemResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeleteBudgetItemResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeleteBudgetItemResultForArrayConstraintsFromSetDeleteBudgetItemResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteBudgetItemResultArrayDeleteBudgetItemResultItem) {
            // validation for constraint: itemType
            if (!$deleteBudgetItemResultArrayDeleteBudgetItemResultItem instanceof \StructType\DeleteBudgetItemResult) {
                $invalidValues[] = is_object($deleteBudgetItemResultArrayDeleteBudgetItemResultItem) ? get_class($deleteBudgetItemResultArrayDeleteBudgetItemResultItem) : sprintf('%s(%s)', gettype($deleteBudgetItemResultArrayDeleteBudgetItemResultItem), var_export($deleteBudgetItemResultArrayDeleteBudgetItemResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeleteBudgetItemResult property can only contain items of type \StructType\DeleteBudgetItemResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeleteBudgetItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteBudgetItemResult[] $deleteBudgetItemResult
     * @return \ArrayType\DeleteBudgetItemResultArray
     */
    public function setDeleteBudgetItemResult(array $deleteBudgetItemResult = array())
    {
        // validation for constraint: array
        if ('' !== ($deleteBudgetItemResultArrayErrorMessage = self::validateDeleteBudgetItemResultForArrayConstraintsFromSetDeleteBudgetItemResult($deleteBudgetItemResult))) {
            throw new \InvalidArgumentException($deleteBudgetItemResultArrayErrorMessage, __LINE__);
        }
        $this->DeleteBudgetItemResult = $deleteBudgetItemResult;
        return $this;
    }
    /**
     * Add item to DeleteBudgetItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteBudgetItemResult $item
     * @return \ArrayType\DeleteBudgetItemResultArray
     */
    public function addToDeleteBudgetItemResult(\StructType\DeleteBudgetItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteBudgetItemResult) {
            throw new \InvalidArgumentException(sprintf('The DeleteBudgetItemResult property can only contain items of type \StructType\DeleteBudgetItemResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeleteBudgetItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteBudgetItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteBudgetItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteBudgetItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteBudgetItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteBudgetItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteBudgetItemResult
     */
    public function getAttributeName()
    {
        return 'DeleteBudgetItemResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\DeleteBudgetItemResultArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
