<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for CvObjectTypeArray ArrayType
 * @subpackage Arrays
 */
class CvObjectTypeArray extends AbstractStructArrayBase
{
    /**
     * The CvObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CvObjectType;
    /**
     * Constructor method for CvObjectTypeArray
     * @uses CvObjectTypeArray::setCvObjectType()
     * @param string[] $cvObjectType
     */
    public function __construct(array $cvObjectType = array())
    {
        $this
            ->setCvObjectType($cvObjectType);
    }
    /**
     * Get CvObjectType value
     * @return string[]|null
     */
    public function getCvObjectType()
    {
        return $this->CvObjectType;
    }
    /**
     * This method is responsible for validating the values passed to the setCvObjectType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCvObjectType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCvObjectTypeForArrayConstraintsFromSetCvObjectType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cvObjectTypeArrayCvObjectTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CvObjectType::valueIsValid($cvObjectTypeArrayCvObjectTypeItem)) {
                $invalidValues[] = is_object($cvObjectTypeArrayCvObjectTypeItem) ? get_class($cvObjectTypeArrayCvObjectTypeItem) : sprintf('%s(%s)', gettype($cvObjectTypeArrayCvObjectTypeItem), var_export($cvObjectTypeArrayCvObjectTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvObjectType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CvObjectType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CvObjectType value
     * @uses \EnumType\CvObjectType::valueIsValid()
     * @uses \EnumType\CvObjectType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $cvObjectType
     * @return \ArrayType\CvObjectTypeArray
     */
    public function setCvObjectType(array $cvObjectType = array())
    {
        // validation for constraint: array
        if ('' !== ($cvObjectTypeArrayErrorMessage = self::validateCvObjectTypeForArrayConstraintsFromSetCvObjectType($cvObjectType))) {
            throw new \InvalidArgumentException($cvObjectTypeArrayErrorMessage, __LINE__);
        }
        $this->CvObjectType = $cvObjectType;
        return $this;
    }
    /**
     * Add item to CvObjectType value
     * @uses \EnumType\CvObjectType::valueIsValid()
     * @uses \EnumType\CvObjectType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\CvObjectTypeArray
     */
    public function addToCvObjectType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvObjectType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvObjectType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\CvObjectType::getValidValues())), __LINE__);
        }
        $this->CvObjectType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\CvObjectType::valueIsValid()
     * @param string $item
     * @return \ArrayType\CvObjectTypeArray
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvObjectType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvObjectType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\CvObjectType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CvObjectType
     */
    public function getAttributeName()
    {
        return 'CvObjectType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\CvObjectTypeArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
