<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for CheckInResultArray ArrayType
 * @subpackage Arrays
 */
class CheckInResultArray extends AbstractStructArrayBase
{
    /**
     * The CheckInResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CheckInResult[]
     */
    public $CheckInResult;
    /**
     * Constructor method for CheckInResultArray
     * @uses CheckInResultArray::setCheckInResult()
     * @param \StructType\CheckInResult[] $checkInResult
     */
    public function __construct(array $checkInResult = array())
    {
        $this
            ->setCheckInResult($checkInResult);
    }
    /**
     * Get CheckInResult value
     * @return \StructType\CheckInResult[]|null
     */
    public function getCheckInResult()
    {
        return $this->CheckInResult;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckInResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckInResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckInResultForArrayConstraintsFromSetCheckInResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $checkInResultArrayCheckInResultItem) {
            // validation for constraint: itemType
            if (!$checkInResultArrayCheckInResultItem instanceof \StructType\CheckInResult) {
                $invalidValues[] = is_object($checkInResultArrayCheckInResultItem) ? get_class($checkInResultArrayCheckInResultItem) : sprintf('%s(%s)', gettype($checkInResultArrayCheckInResultItem), var_export($checkInResultArrayCheckInResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CheckInResult property can only contain items of type \StructType\CheckInResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CheckInResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckInResult[] $checkInResult
     * @return \ArrayType\CheckInResultArray
     */
    public function setCheckInResult(array $checkInResult = array())
    {
        // validation for constraint: array
        if ('' !== ($checkInResultArrayErrorMessage = self::validateCheckInResultForArrayConstraintsFromSetCheckInResult($checkInResult))) {
            throw new \InvalidArgumentException($checkInResultArrayErrorMessage, __LINE__);
        }
        $this->CheckInResult = $checkInResult;
        return $this;
    }
    /**
     * Add item to CheckInResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckInResult $item
     * @return \ArrayType\CheckInResultArray
     */
    public function addToCheckInResult(\StructType\CheckInResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CheckInResult) {
            throw new \InvalidArgumentException(sprintf('The CheckInResult property can only contain items of type \StructType\CheckInResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CheckInResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CheckInResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CheckInResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CheckInResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CheckInResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CheckInResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CheckInResult
     */
    public function getAttributeName()
    {
        return 'CheckInResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\CheckInResultArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
