<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSession ArrayType
 * @subpackage Arrays
 */
class ArrayOfSession extends AbstractStructArrayBase
{
    /**
     * The Session
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Session[]
     */
    public $Session;
    /**
     * Constructor method for ArrayOfSession
     * @uses ArrayOfSession::setSession()
     * @param \StructType\Session[] $session
     */
    public function __construct(array $session = array())
    {
        $this
            ->setSession($session);
    }
    /**
     * Get Session value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Session[]|null
     */
    public function getSession()
    {
        return isset($this->Session) ? $this->Session : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSession method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSession method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSessionForArrayConstraintsFromSetSession(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSessionSessionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSessionSessionItem instanceof \StructType\Session) {
                $invalidValues[] = is_object($arrayOfSessionSessionItem) ? get_class($arrayOfSessionSessionItem) : sprintf('%s(%s)', gettype($arrayOfSessionSessionItem), var_export($arrayOfSessionSessionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Session property can only contain items of type \StructType\Session, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Session value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Session[] $session
     * @return \ArrayType\ArrayOfSession
     */
    public function setSession(array $session = array())
    {
        // validation for constraint: array
        if ('' !== ($sessionArrayErrorMessage = self::validateSessionForArrayConstraintsFromSetSession($session))) {
            throw new \InvalidArgumentException($sessionArrayErrorMessage, __LINE__);
        }
        if (is_null($session) || (is_array($session) && empty($session))) {
            unset($this->Session);
        } else {
            $this->Session = $session;
        }
        return $this;
    }
    /**
     * Add item to Session value
     * @throws \InvalidArgumentException
     * @param \StructType\Session $item
     * @return \ArrayType\ArrayOfSession
     */
    public function addToSession(\StructType\Session $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Session) {
            throw new \InvalidArgumentException(sprintf('The Session property can only contain items of type \StructType\Session, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Session[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Session|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Session|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Session|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Session|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Session|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Session
     */
    public function getAttributeName()
    {
        return 'Session';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSession
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
