<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRFPParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfRFPParameters extends AbstractStructArrayBase
{
    /**
     * The RFPParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RFPParameters[]
     */
    public $RFPParameters;
    /**
     * Constructor method for ArrayOfRFPParameters
     * @uses ArrayOfRFPParameters::setRFPParameters()
     * @param \StructType\RFPParameters[] $rFPParameters
     */
    public function __construct(array $rFPParameters = array())
    {
        $this
            ->setRFPParameters($rFPParameters);
    }
    /**
     * Get RFPParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RFPParameters[]|null
     */
    public function getRFPParameters()
    {
        return isset($this->RFPParameters) ? $this->RFPParameters : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRFPParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFPParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFPParametersForArrayConstraintsFromSetRFPParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRFPParametersRFPParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfRFPParametersRFPParametersItem instanceof \StructType\RFPParameters) {
                $invalidValues[] = is_object($arrayOfRFPParametersRFPParametersItem) ? get_class($arrayOfRFPParametersRFPParametersItem) : sprintf('%s(%s)', gettype($arrayOfRFPParametersRFPParametersItem), var_export($arrayOfRFPParametersRFPParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFPParameters property can only contain items of type \StructType\RFPParameters, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFPParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RFPParameters[] $rFPParameters
     * @return \ArrayType\ArrayOfRFPParameters
     */
    public function setRFPParameters(array $rFPParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($rFPParametersArrayErrorMessage = self::validateRFPParametersForArrayConstraintsFromSetRFPParameters($rFPParameters))) {
            throw new \InvalidArgumentException($rFPParametersArrayErrorMessage, __LINE__);
        }
        if (is_null($rFPParameters) || (is_array($rFPParameters) && empty($rFPParameters))) {
            unset($this->RFPParameters);
        } else {
            $this->RFPParameters = $rFPParameters;
        }
        return $this;
    }
    /**
     * Add item to RFPParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPParameters $item
     * @return \ArrayType\ArrayOfRFPParameters
     */
    public function addToRFPParameters(\StructType\RFPParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPParameters) {
            throw new \InvalidArgumentException(sprintf('The RFPParameters property can only contain items of type \StructType\RFPParameters, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFPParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RFPParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RFPParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RFPParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RFPParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RFPParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RFPParameters
     */
    public function getAttributeName()
    {
        return 'RFPParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRFPParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
