<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventParameters extends AbstractStructArrayBase
{
    /**
     * The EventParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EventParameters[]
     */
    public $EventParameters;
    /**
     * Constructor method for ArrayOfEventParameters
     * @uses ArrayOfEventParameters::setEventParameters()
     * @param \StructType\EventParameters[] $eventParameters
     */
    public function __construct(array $eventParameters = array())
    {
        $this
            ->setEventParameters($eventParameters);
    }
    /**
     * Get EventParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EventParameters[]|null
     */
    public function getEventParameters()
    {
        return isset($this->EventParameters) ? $this->EventParameters : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventParametersForArrayConstraintsFromSetEventParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventParametersEventParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventParametersEventParametersItem instanceof \StructType\EventParameters) {
                $invalidValues[] = is_object($arrayOfEventParametersEventParametersItem) ? get_class($arrayOfEventParametersEventParametersItem) : sprintf('%s(%s)', gettype($arrayOfEventParametersEventParametersItem), var_export($arrayOfEventParametersEventParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventParameters property can only contain items of type \StructType\EventParameters, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EventParameters[] $eventParameters
     * @return \ArrayType\ArrayOfEventParameters
     */
    public function setEventParameters(array $eventParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($eventParametersArrayErrorMessage = self::validateEventParametersForArrayConstraintsFromSetEventParameters($eventParameters))) {
            throw new \InvalidArgumentException($eventParametersArrayErrorMessage, __LINE__);
        }
        if (is_null($eventParameters) || (is_array($eventParameters) && empty($eventParameters))) {
            unset($this->EventParameters);
        } else {
            $this->EventParameters = $eventParameters;
        }
        return $this;
    }
    /**
     * Add item to EventParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EventParameters $item
     * @return \ArrayType\ArrayOfEventParameters
     */
    public function addToEventParameters(\StructType\EventParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventParameters) {
            throw new \InvalidArgumentException(sprintf('The EventParameters property can only contain items of type \StructType\EventParameters, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EventParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EventParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EventParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EventParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EventParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventParameters
     */
    public function getAttributeName()
    {
        return 'EventParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEventParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
